/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerregistry.fluent.ContainerRegistryManagementClient;
import com.azure.resourcemanager.containerregistry.fluent.OperationsClient;
import com.azure.resourcemanager.containerregistry.fluent.RegistriesClient;
import com.azure.resourcemanager.containerregistry.fluent.ReplicationsClient;
import com.azure.resourcemanager.containerregistry.fluent.RunsClient;
import com.azure.resourcemanager.containerregistry.fluent.TasksClient;
import com.azure.resourcemanager.containerregistry.fluent.WebhooksClient;
import com.azure.resourcemanager.containerregistry.implementation.ContainerRegistryManagementClientBuilder;
import com.azure.resourcemanager.containerregistry.implementation.OperationsClientImpl;
import com.azure.resourcemanager.containerregistry.implementation.RegistriesClientImpl;
import com.azure.resourcemanager.containerregistry.implementation.ReplicationsClientImpl;
import com.azure.resourcemanager.containerregistry.implementation.RunsClientImpl;
import com.azure.resourcemanager.containerregistry.implementation.TasksClientImpl;
import com.azure.resourcemanager.containerregistry.implementation.WebhooksClientImpl;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

@ServiceClient(builder=ContainerRegistryManagementClientBuilder.class)
public final class ContainerRegistryManagementClientImpl
extends AzureServiceClient
implements ContainerRegistryManagementClient {
    private final ClientLogger logger = new ClientLogger(ContainerRegistryManagementClientImpl.class);
    private final String subscriptionId;
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final RegistriesClient registries;
    private final OperationsClient operations;
    private final ReplicationsClient replications;
    private final WebhooksClient webhooks;
    private final RunsClient runs;
    private final TasksClient tasks;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public RegistriesClient getRegistries() {
        return this.registries;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public ReplicationsClient getReplications() {
        return this.replications;
    }

    @Override
    public WebhooksClient getWebhooks() {
        return this.webhooks;
    }

    @Override
    public RunsClient getRuns() {
        return this.runs;
    }

    @Override
    public TasksClient getTasks() {
        return this.tasks;
    }

    ContainerRegistryManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.registries = new RegistriesClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.replications = new ReplicationsClientImpl(this);
        this.webhooks = new WebhooksClientImpl(this);
        this.runs = new RunsClientImpl(this);
        this.tasks = new TasksClientImpl(this);
    }
}

