/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.NetworkRuleSet;
import com.azure.resourcemanager.containerregistry.models.Policies;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.Sku;
import com.azure.resourcemanager.containerregistry.models.Status;
import com.azure.resourcemanager.containerregistry.models.StorageAccountProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

@JsonFlatten
public class RegistryInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RegistryInner.class);
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    @JsonProperty(value="properties.loginServer", access=JsonProperty.Access.WRITE_ONLY)
    private String loginServer;
    @JsonProperty(value="properties.creationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.status", access=JsonProperty.Access.WRITE_ONLY)
    private Status status;
    @JsonProperty(value="properties.adminUserEnabled")
    private Boolean adminUserEnabled;
    @JsonProperty(value="properties.storageAccount")
    private StorageAccountProperties storageAccount;
    @JsonProperty(value="properties.networkRuleSet")
    private NetworkRuleSet networkRuleSet;
    @JsonProperty(value="properties.policies")
    private Policies policies;

    public Sku sku() {
        return this.sku;
    }

    public RegistryInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String loginServer() {
        return this.loginServer;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Status status() {
        return this.status;
    }

    public Boolean adminUserEnabled() {
        return this.adminUserEnabled;
    }

    public RegistryInner withAdminUserEnabled(Boolean adminUserEnabled) {
        this.adminUserEnabled = adminUserEnabled;
        return this;
    }

    public StorageAccountProperties storageAccount() {
        return this.storageAccount;
    }

    public RegistryInner withStorageAccount(StorageAccountProperties storageAccount) {
        this.storageAccount = storageAccount;
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.networkRuleSet;
    }

    public RegistryInner withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        this.networkRuleSet = networkRuleSet;
        return this;
    }

    public Policies policies() {
        return this.policies;
    }

    public RegistryInner withPolicies(Policies policies) {
        this.policies = policies;
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model RegistryInner"));
        }
        this.sku().validate();
        if (this.status() != null) {
            this.status().validate();
        }
        if (this.storageAccount() != null) {
            this.storageAccount().validate();
        }
        if (this.networkRuleSet() != null) {
            this.networkRuleSet().validate();
        }
        if (this.policies() != null) {
            this.policies().validate();
        }
    }
}

