/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.OperationPropertiesDefinition;
import com.azure.resourcemanager.containerregistry.models.OperationDisplayDefinition;
import com.azure.resourcemanager.containerregistry.models.OperationServiceSpecificationDefinition;
import java.io.IOException;

public final class OperationDefinitionInner
implements JsonSerializable<OperationDefinitionInner> {
    private String origin;
    private String name;
    private OperationDisplayDefinition display;
    private OperationPropertiesDefinition innerProperties;
    private Boolean isDataAction;

    public String origin() {
        return this.origin;
    }

    public OperationDefinitionInner withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public String name() {
        return this.name;
    }

    public OperationDefinitionInner withName(String name) {
        this.name = name;
        return this;
    }

    public OperationDisplayDefinition display() {
        return this.display;
    }

    public OperationDefinitionInner withDisplay(OperationDisplayDefinition display) {
        this.display = display;
        return this;
    }

    private OperationPropertiesDefinition innerProperties() {
        return this.innerProperties;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public OperationDefinitionInner withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public OperationServiceSpecificationDefinition serviceSpecification() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceSpecification();
    }

    public OperationDefinitionInner withServiceSpecification(OperationServiceSpecificationDefinition serviceSpecification) {
        if (this.innerProperties() == null) {
            this.innerProperties = new OperationPropertiesDefinition();
        }
        this.innerProperties().withServiceSpecification(serviceSpecification);
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("origin", this.origin);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        return jsonWriter.writeEndObject();
    }

    public static OperationDefinitionInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationDefinitionInner)jsonReader.readObject(reader -> {
            OperationDefinitionInner deserializedOperationDefinitionInner = new OperationDefinitionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("origin".equals(fieldName)) {
                    deserializedOperationDefinitionInner.origin = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOperationDefinitionInner.name = reader.getString();
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperationDefinitionInner.display = OperationDisplayDefinition.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOperationDefinitionInner.innerProperties = OperationPropertiesDefinition.fromJson(reader);
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedOperationDefinitionInner.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationDefinitionInner;
        });
    }
}

