/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.ActivationProperties;
import com.azure.resourcemanager.containerregistry.models.ConnectedRegistryMode;
import com.azure.resourcemanager.containerregistry.models.ConnectionState;
import com.azure.resourcemanager.containerregistry.models.GarbageCollectionProperties;
import com.azure.resourcemanager.containerregistry.models.LoggingProperties;
import com.azure.resourcemanager.containerregistry.models.LoginServerProperties;
import com.azure.resourcemanager.containerregistry.models.ParentProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.StatusDetailProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ConnectedRegistryProperties
implements JsonSerializable<ConnectedRegistryProperties> {
    private ProvisioningState provisioningState;
    private ConnectedRegistryMode mode;
    private String version;
    private ConnectionState connectionState;
    private OffsetDateTime lastActivityTime;
    private ActivationProperties activation;
    private ParentProperties parent;
    private List<String> clientTokenIds;
    private LoginServerProperties loginServer;
    private LoggingProperties logging;
    private List<StatusDetailProperties> statusDetails;
    private List<String> notificationsList;
    private GarbageCollectionProperties garbageCollection;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectedRegistryProperties.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ConnectedRegistryMode mode() {
        return this.mode;
    }

    public ConnectedRegistryProperties withMode(ConnectedRegistryMode mode) {
        this.mode = mode;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ConnectionState connectionState() {
        return this.connectionState;
    }

    public OffsetDateTime lastActivityTime() {
        return this.lastActivityTime;
    }

    public ActivationProperties activation() {
        return this.activation;
    }

    public ParentProperties parent() {
        return this.parent;
    }

    public ConnectedRegistryProperties withParent(ParentProperties parent) {
        this.parent = parent;
        return this;
    }

    public List<String> clientTokenIds() {
        return this.clientTokenIds;
    }

    public ConnectedRegistryProperties withClientTokenIds(List<String> clientTokenIds) {
        this.clientTokenIds = clientTokenIds;
        return this;
    }

    public LoginServerProperties loginServer() {
        return this.loginServer;
    }

    public ConnectedRegistryProperties withLoginServer(LoginServerProperties loginServer) {
        this.loginServer = loginServer;
        return this;
    }

    public LoggingProperties logging() {
        return this.logging;
    }

    public ConnectedRegistryProperties withLogging(LoggingProperties logging) {
        this.logging = logging;
        return this;
    }

    public List<StatusDetailProperties> statusDetails() {
        return this.statusDetails;
    }

    public List<String> notificationsList() {
        return this.notificationsList;
    }

    public ConnectedRegistryProperties withNotificationsList(List<String> notificationsList) {
        this.notificationsList = notificationsList;
        return this;
    }

    public GarbageCollectionProperties garbageCollection() {
        return this.garbageCollection;
    }

    public ConnectedRegistryProperties withGarbageCollection(GarbageCollectionProperties garbageCollection) {
        this.garbageCollection = garbageCollection;
        return this;
    }

    public void validate() {
        if (this.mode() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property mode in model ConnectedRegistryProperties"));
        }
        if (this.activation() != null) {
            this.activation().validate();
        }
        if (this.parent() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property parent in model ConnectedRegistryProperties"));
        }
        this.parent().validate();
        if (this.loginServer() != null) {
            this.loginServer().validate();
        }
        if (this.logging() != null) {
            this.logging().validate();
        }
        if (this.statusDetails() != null) {
            this.statusDetails().forEach(e -> e.validate());
        }
        if (this.garbageCollection() != null) {
            this.garbageCollection().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeJsonField("parent", (JsonSerializable)this.parent);
        jsonWriter.writeArrayField("clientTokenIds", this.clientTokenIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("loginServer", (JsonSerializable)this.loginServer);
        jsonWriter.writeJsonField("logging", (JsonSerializable)this.logging);
        jsonWriter.writeArrayField("notificationsList", this.notificationsList, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("garbageCollection", (JsonSerializable)this.garbageCollection);
        return jsonWriter.writeEndObject();
    }

    public static ConnectedRegistryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectedRegistryProperties)jsonReader.readObject(reader -> {
            ConnectedRegistryProperties deserializedConnectedRegistryProperties = new ConnectedRegistryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("mode".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.mode = ConnectedRegistryMode.fromString(reader.getString());
                    continue;
                }
                if ("parent".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.parent = ParentProperties.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.version = reader.getString();
                    continue;
                }
                if ("connectionState".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.connectionState = ConnectionState.fromString(reader.getString());
                    continue;
                }
                if ("lastActivityTime".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.lastActivityTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("activation".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.activation = ActivationProperties.fromJson(reader);
                    continue;
                }
                if ("clientTokenIds".equals(fieldName)) {
                    List clientTokenIds;
                    deserializedConnectedRegistryProperties.clientTokenIds = clientTokenIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("loginServer".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.loginServer = LoginServerProperties.fromJson(reader);
                    continue;
                }
                if ("logging".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.logging = LoggingProperties.fromJson(reader);
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    List statusDetails;
                    deserializedConnectedRegistryProperties.statusDetails = statusDetails = reader.readArray(reader1 -> StatusDetailProperties.fromJson(reader1));
                    continue;
                }
                if ("notificationsList".equals(fieldName)) {
                    List notificationsList;
                    deserializedConnectedRegistryProperties.notificationsList = notificationsList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("garbageCollection".equals(fieldName)) {
                    deserializedConnectedRegistryProperties.garbageCollection = GarbageCollectionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectedRegistryProperties;
        });
    }
}

