/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.TokenPasswordName;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class GenerateCredentialsParameters
implements JsonSerializable<GenerateCredentialsParameters> {
    private String tokenId;
    private OffsetDateTime expiry;
    private TokenPasswordName name;

    public String tokenId() {
        return this.tokenId;
    }

    public GenerateCredentialsParameters withTokenId(String tokenId) {
        this.tokenId = tokenId;
        return this;
    }

    public OffsetDateTime expiry() {
        return this.expiry;
    }

    public GenerateCredentialsParameters withExpiry(OffsetDateTime expiry) {
        this.expiry = expiry;
        return this;
    }

    public TokenPasswordName name() {
        return this.name;
    }

    public GenerateCredentialsParameters withName(TokenPasswordName name) {
        this.name = name;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tokenId", this.tokenId);
        jsonWriter.writeStringField("expiry", this.expiry == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiry));
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static GenerateCredentialsParameters fromJson(JsonReader jsonReader) throws IOException {
        return (GenerateCredentialsParameters)jsonReader.readObject(reader -> {
            GenerateCredentialsParameters deserializedGenerateCredentialsParameters = new GenerateCredentialsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tokenId".equals(fieldName)) {
                    deserializedGenerateCredentialsParameters.tokenId = reader.getString();
                    continue;
                }
                if ("expiry".equals(fieldName)) {
                    deserializedGenerateCredentialsParameters.expiry = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGenerateCredentialsParameters.name = TokenPasswordName.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGenerateCredentialsParameters;
        });
    }
}

