/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.Actor;
import com.azure.resourcemanager.containerregistry.models.Request;
import com.azure.resourcemanager.containerregistry.models.Source;
import com.azure.resourcemanager.containerregistry.models.Target;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class EventContent
implements JsonSerializable<EventContent> {
    private String id;
    private OffsetDateTime timestamp;
    private String action;
    private Target target;
    private Request request;
    private Actor actor;
    private Source source;

    public String id() {
        return this.id;
    }

    public EventContent withId(String id) {
        this.id = id;
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public EventContent withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String action() {
        return this.action;
    }

    public EventContent withAction(String action) {
        this.action = action;
        return this;
    }

    public Target target() {
        return this.target;
    }

    public EventContent withTarget(Target target) {
        this.target = target;
        return this;
    }

    public Request request() {
        return this.request;
    }

    public EventContent withRequest(Request request) {
        this.request = request;
        return this;
    }

    public Actor actor() {
        return this.actor;
    }

    public EventContent withActor(Actor actor) {
        this.actor = actor;
        return this;
    }

    public Source source() {
        return this.source;
    }

    public EventContent withSource(Source source) {
        this.source = source;
        return this;
    }

    public void validate() {
        if (this.target() != null) {
            this.target().validate();
        }
        if (this.request() != null) {
            this.request().validate();
        }
        if (this.actor() != null) {
            this.actor().validate();
        }
        if (this.source() != null) {
            this.source().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("action", this.action);
        jsonWriter.writeJsonField("target", (JsonSerializable)this.target);
        jsonWriter.writeJsonField("request", (JsonSerializable)this.request);
        jsonWriter.writeJsonField("actor", (JsonSerializable)this.actor);
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        return jsonWriter.writeEndObject();
    }

    public static EventContent fromJson(JsonReader jsonReader) throws IOException {
        return (EventContent)jsonReader.readObject(reader -> {
            EventContent deserializedEventContent = new EventContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedEventContent.id = reader.getString();
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedEventContent.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedEventContent.action = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedEventContent.target = Target.fromJson(reader);
                    continue;
                }
                if ("request".equals(fieldName)) {
                    deserializedEventContent.request = Request.fromJson(reader);
                    continue;
                }
                if ("actor".equals(fieldName)) {
                    deserializedEventContent.actor = Actor.fromJson(reader);
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedEventContent.source = Source.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventContent;
        });
    }
}

