/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.TokenPassword;
import java.io.IOException;
import java.util.List;

public final class GenerateCredentialsResultInner
implements JsonSerializable<GenerateCredentialsResultInner> {
    private String username;
    private List<TokenPassword> passwords;

    public String username() {
        return this.username;
    }

    public GenerateCredentialsResultInner withUsername(String username) {
        this.username = username;
        return this;
    }

    public List<TokenPassword> passwords() {
        return this.passwords;
    }

    public GenerateCredentialsResultInner withPasswords(List<TokenPassword> passwords) {
        this.passwords = passwords;
        return this;
    }

    public void validate() {
        if (this.passwords() != null) {
            this.passwords().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeArrayField("passwords", this.passwords, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static GenerateCredentialsResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (GenerateCredentialsResultInner)jsonReader.readObject(reader -> {
            GenerateCredentialsResultInner deserializedGenerateCredentialsResultInner = new GenerateCredentialsResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("username".equals(fieldName)) {
                    deserializedGenerateCredentialsResultInner.username = reader.getString();
                    continue;
                }
                if ("passwords".equals(fieldName)) {
                    List passwords;
                    deserializedGenerateCredentialsResultInner.passwords = passwords = reader.readArray(reader1 -> TokenPassword.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGenerateCredentialsResultInner;
        });
    }
}

