/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.GarbageCollectionProperties;
import com.azure.resourcemanager.containerregistry.models.LoggingProperties;
import com.azure.resourcemanager.containerregistry.models.SyncUpdateProperties;
import java.io.IOException;
import java.util.List;

public final class ConnectedRegistryUpdateProperties
implements JsonSerializable<ConnectedRegistryUpdateProperties> {
    private SyncUpdateProperties syncProperties;
    private LoggingProperties logging;
    private List<String> clientTokenIds;
    private List<String> notificationsList;
    private GarbageCollectionProperties garbageCollection;

    public SyncUpdateProperties syncProperties() {
        return this.syncProperties;
    }

    public ConnectedRegistryUpdateProperties withSyncProperties(SyncUpdateProperties syncProperties) {
        this.syncProperties = syncProperties;
        return this;
    }

    public LoggingProperties logging() {
        return this.logging;
    }

    public ConnectedRegistryUpdateProperties withLogging(LoggingProperties logging) {
        this.logging = logging;
        return this;
    }

    public List<String> clientTokenIds() {
        return this.clientTokenIds;
    }

    public ConnectedRegistryUpdateProperties withClientTokenIds(List<String> clientTokenIds) {
        this.clientTokenIds = clientTokenIds;
        return this;
    }

    public List<String> notificationsList() {
        return this.notificationsList;
    }

    public ConnectedRegistryUpdateProperties withNotificationsList(List<String> notificationsList) {
        this.notificationsList = notificationsList;
        return this;
    }

    public GarbageCollectionProperties garbageCollection() {
        return this.garbageCollection;
    }

    public ConnectedRegistryUpdateProperties withGarbageCollection(GarbageCollectionProperties garbageCollection) {
        this.garbageCollection = garbageCollection;
        return this;
    }

    public void validate() {
        if (this.syncProperties() != null) {
            this.syncProperties().validate();
        }
        if (this.logging() != null) {
            this.logging().validate();
        }
        if (this.garbageCollection() != null) {
            this.garbageCollection().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("syncProperties", (JsonSerializable)this.syncProperties);
        jsonWriter.writeJsonField("logging", (JsonSerializable)this.logging);
        jsonWriter.writeArrayField("clientTokenIds", this.clientTokenIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("notificationsList", this.notificationsList, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("garbageCollection", (JsonSerializable)this.garbageCollection);
        return jsonWriter.writeEndObject();
    }

    public static ConnectedRegistryUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectedRegistryUpdateProperties)jsonReader.readObject(reader -> {
            ConnectedRegistryUpdateProperties deserializedConnectedRegistryUpdateProperties = new ConnectedRegistryUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("syncProperties".equals(fieldName)) {
                    deserializedConnectedRegistryUpdateProperties.syncProperties = SyncUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("logging".equals(fieldName)) {
                    deserializedConnectedRegistryUpdateProperties.logging = LoggingProperties.fromJson(reader);
                    continue;
                }
                if ("clientTokenIds".equals(fieldName)) {
                    List clientTokenIds;
                    deserializedConnectedRegistryUpdateProperties.clientTokenIds = clientTokenIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("notificationsList".equals(fieldName)) {
                    List notificationsList;
                    deserializedConnectedRegistryUpdateProperties.notificationsList = notificationsList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("garbageCollection".equals(fieldName)) {
                    deserializedConnectedRegistryUpdateProperties.garbageCollection = GarbageCollectionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectedRegistryUpdateProperties;
        });
    }
}

