/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.TokenCertificate;
import com.azure.resourcemanager.containerregistry.models.TokenPassword;
import java.io.IOException;
import java.util.List;

public final class TokenCredentialsProperties
implements JsonSerializable<TokenCredentialsProperties> {
    private List<TokenCertificate> certificates;
    private List<TokenPassword> passwords;

    public List<TokenCertificate> certificates() {
        return this.certificates;
    }

    public TokenCredentialsProperties withCertificates(List<TokenCertificate> certificates) {
        this.certificates = certificates;
        return this;
    }

    public List<TokenPassword> passwords() {
        return this.passwords;
    }

    public TokenCredentialsProperties withPasswords(List<TokenPassword> passwords) {
        this.passwords = passwords;
        return this;
    }

    public void validate() {
        if (this.certificates() != null) {
            this.certificates().forEach(e -> e.validate());
        }
        if (this.passwords() != null) {
            this.passwords().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("certificates", this.certificates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("passwords", this.passwords, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TokenCredentialsProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TokenCredentialsProperties)jsonReader.readObject(reader -> {
            TokenCredentialsProperties deserializedTokenCredentialsProperties = new TokenCredentialsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("certificates".equals(fieldName)) {
                    List certificates;
                    deserializedTokenCredentialsProperties.certificates = certificates = reader.readArray(reader1 -> TokenCertificate.fromJson(reader1));
                    continue;
                }
                if ("passwords".equals(fieldName)) {
                    List passwords;
                    deserializedTokenCredentialsProperties.passwords = passwords = reader.readArray(reader1 -> TokenPassword.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTokenCredentialsProperties;
        });
    }
}

