/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;

public final class SyncProperties
implements JsonSerializable<SyncProperties> {
    private String tokenId;
    private String schedule;
    private Duration syncWindow;
    private Duration messageTtl;
    private OffsetDateTime lastSyncTime;
    private String gatewayEndpoint;
    private static final ClientLogger LOGGER = new ClientLogger(SyncProperties.class);

    public String tokenId() {
        return this.tokenId;
    }

    public SyncProperties withTokenId(String tokenId) {
        this.tokenId = tokenId;
        return this;
    }

    public String schedule() {
        return this.schedule;
    }

    public SyncProperties withSchedule(String schedule) {
        this.schedule = schedule;
        return this;
    }

    public Duration syncWindow() {
        return this.syncWindow;
    }

    public SyncProperties withSyncWindow(Duration syncWindow) {
        this.syncWindow = syncWindow;
        return this;
    }

    public Duration messageTtl() {
        return this.messageTtl;
    }

    public SyncProperties withMessageTtl(Duration messageTtl) {
        this.messageTtl = messageTtl;
        return this;
    }

    public OffsetDateTime lastSyncTime() {
        return this.lastSyncTime;
    }

    public String gatewayEndpoint() {
        return this.gatewayEndpoint;
    }

    public void validate() {
        if (this.tokenId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tokenId in model SyncProperties"));
        }
        if (this.messageTtl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property messageTtl in model SyncProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tokenId", this.tokenId);
        jsonWriter.writeStringField("messageTtl", CoreUtils.durationToStringWithDays((Duration)this.messageTtl));
        jsonWriter.writeStringField("schedule", this.schedule);
        jsonWriter.writeStringField("syncWindow", CoreUtils.durationToStringWithDays((Duration)this.syncWindow));
        return jsonWriter.writeEndObject();
    }

    public static SyncProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SyncProperties)jsonReader.readObject(reader -> {
            SyncProperties deserializedSyncProperties = new SyncProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tokenId".equals(fieldName)) {
                    deserializedSyncProperties.tokenId = reader.getString();
                    continue;
                }
                if ("messageTtl".equals(fieldName)) {
                    deserializedSyncProperties.messageTtl = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("schedule".equals(fieldName)) {
                    deserializedSyncProperties.schedule = reader.getString();
                    continue;
                }
                if ("syncWindow".equals(fieldName)) {
                    deserializedSyncProperties.syncWindow = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("lastSyncTime".equals(fieldName)) {
                    deserializedSyncProperties.lastSyncTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("gatewayEndpoint".equals(fieldName)) {
                    deserializedSyncProperties.gatewayEndpoint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSyncProperties;
        });
    }
}

