/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.ImportSourceCredentials;
import java.io.IOException;

public final class ImportSource
implements JsonSerializable<ImportSource> {
    private String resourceId;
    private String registryUri;
    private ImportSourceCredentials credentials;
    private String sourceImage;
    private static final ClientLogger LOGGER = new ClientLogger(ImportSource.class);

    public String resourceId() {
        return this.resourceId;
    }

    public ImportSource withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String registryUri() {
        return this.registryUri;
    }

    public ImportSource withRegistryUri(String registryUri) {
        this.registryUri = registryUri;
        return this;
    }

    public ImportSourceCredentials credentials() {
        return this.credentials;
    }

    public ImportSource withCredentials(ImportSourceCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public String sourceImage() {
        return this.sourceImage;
    }

    public ImportSource withSourceImage(String sourceImage) {
        this.sourceImage = sourceImage;
        return this;
    }

    public void validate() {
        if (this.credentials() != null) {
            this.credentials().validate();
        }
        if (this.sourceImage() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceImage in model ImportSource"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceImage", this.sourceImage);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("registryUri", this.registryUri);
        jsonWriter.writeJsonField("credentials", (JsonSerializable)this.credentials);
        return jsonWriter.writeEndObject();
    }

    public static ImportSource fromJson(JsonReader jsonReader) throws IOException {
        return (ImportSource)jsonReader.readObject(reader -> {
            ImportSource deserializedImportSource = new ImportSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceImage".equals(fieldName)) {
                    deserializedImportSource.sourceImage = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedImportSource.resourceId = reader.getString();
                    continue;
                }
                if ("registryUri".equals(fieldName)) {
                    deserializedImportSource.registryUri = reader.getString();
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    deserializedImportSource.credentials = ImportSourceCredentials.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImportSource;
        });
    }
}

