/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.ResourceIdentityType;
import com.azure.resourcemanager.containerregistry.models.UserIdentityProperties;
import java.io.IOException;
import java.util.Map;

public final class IdentityProperties
implements JsonSerializable<IdentityProperties> {
    private String principalId;
    private String tenantId;
    private ResourceIdentityType type;
    private Map<String, UserIdentityProperties> userAssignedIdentities;

    public String principalId() {
        return this.principalId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public ResourceIdentityType type() {
        return this.type;
    }

    public IdentityProperties withType(ResourceIdentityType type) {
        this.type = type;
        return this;
    }

    public Map<String, UserIdentityProperties> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public IdentityProperties withUserAssignedIdentities(Map<String, UserIdentityProperties> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static IdentityProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IdentityProperties)jsonReader.readObject(reader -> {
            IdentityProperties deserializedIdentityProperties = new IdentityProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("principalId".equals(fieldName)) {
                    deserializedIdentityProperties.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedIdentityProperties.tenantId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIdentityProperties.type = ResourceIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedIdentityProperties.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> UserIdentityProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentityProperties;
        });
    }
}

