/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.TokenCredentialsProperties;
import com.azure.resourcemanager.containerregistry.models.TokenStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class TokenProperties
implements JsonSerializable<TokenProperties> {
    private OffsetDateTime creationDate;
    private ProvisioningState provisioningState;
    private String scopeMapId;
    private TokenCredentialsProperties credentials;
    private TokenStatus status;

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String scopeMapId() {
        return this.scopeMapId;
    }

    public TokenProperties withScopeMapId(String scopeMapId) {
        this.scopeMapId = scopeMapId;
        return this;
    }

    public TokenCredentialsProperties credentials() {
        return this.credentials;
    }

    public TokenProperties withCredentials(TokenCredentialsProperties credentials) {
        this.credentials = credentials;
        return this;
    }

    public TokenStatus status() {
        return this.status;
    }

    public TokenProperties withStatus(TokenStatus status) {
        this.status = status;
        return this;
    }

    public void validate() {
        if (this.credentials() != null) {
            this.credentials().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scopeMapId", this.scopeMapId);
        jsonWriter.writeJsonField("credentials", (JsonSerializable)this.credentials);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static TokenProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TokenProperties)jsonReader.readObject(reader -> {
            TokenProperties deserializedTokenProperties = new TokenProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("creationDate".equals(fieldName)) {
                    deserializedTokenProperties.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedTokenProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("scopeMapId".equals(fieldName)) {
                    deserializedTokenProperties.scopeMapId = reader.getString();
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    deserializedTokenProperties.credentials = TokenCredentialsProperties.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedTokenProperties.status = TokenStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTokenProperties;
        });
    }
}

