/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.AuthCredential;
import java.io.IOException;
import java.util.List;

public final class CredentialSetUpdateProperties
implements JsonSerializable<CredentialSetUpdateProperties> {
    private List<AuthCredential> authCredentials;

    public List<AuthCredential> authCredentials() {
        return this.authCredentials;
    }

    public CredentialSetUpdateProperties withAuthCredentials(List<AuthCredential> authCredentials) {
        this.authCredentials = authCredentials;
        return this;
    }

    public void validate() {
        if (this.authCredentials() != null) {
            this.authCredentials().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("authCredentials", this.authCredentials, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CredentialSetUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CredentialSetUpdateProperties)jsonReader.readObject(reader -> {
            CredentialSetUpdateProperties deserializedCredentialSetUpdateProperties = new CredentialSetUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("authCredentials".equals(fieldName)) {
                    List authCredentials;
                    deserializedCredentialSetUpdateProperties.authCredentials = authCredentials = reader.readArray(reader1 -> AuthCredential.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCredentialSetUpdateProperties;
        });
    }
}

