/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.DockerBuildRequest;
import com.azure.resourcemanager.containerregistry.models.EncodedTaskRunRequest;
import com.azure.resourcemanager.containerregistry.models.FileTaskRunRequest;
import com.azure.resourcemanager.containerregistry.models.TaskRunRequest;
import java.io.IOException;

public class RunRequest
implements JsonSerializable<RunRequest> {
    private String type = "RunRequest";
    private Boolean isArchiveEnabled;
    private String agentPoolName;
    private String logTemplate;

    public String type() {
        return this.type;
    }

    public Boolean isArchiveEnabled() {
        return this.isArchiveEnabled;
    }

    public RunRequest withIsArchiveEnabled(Boolean isArchiveEnabled) {
        this.isArchiveEnabled = isArchiveEnabled;
        return this;
    }

    public String agentPoolName() {
        return this.agentPoolName;
    }

    public RunRequest withAgentPoolName(String agentPoolName) {
        this.agentPoolName = agentPoolName;
        return this;
    }

    public String logTemplate() {
        return this.logTemplate;
    }

    public RunRequest withLogTemplate(String logTemplate) {
        this.logTemplate = logTemplate;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeBooleanField("isArchiveEnabled", this.isArchiveEnabled);
        jsonWriter.writeStringField("agentPoolName", this.agentPoolName);
        jsonWriter.writeStringField("logTemplate", this.logTemplate);
        return jsonWriter.writeEndObject();
    }

    public static RunRequest fromJson(JsonReader jsonReader) throws IOException {
        return (RunRequest)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                RunRequest runRequest;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("DockerBuildRequest".equals(discriminatorValue)) {
                    runRequest = DockerBuildRequest.fromJson(readerToUse.reset());
                    return runRequest;
                }
                if ("FileTaskRunRequest".equals(discriminatorValue)) {
                    runRequest = FileTaskRunRequest.fromJson(readerToUse.reset());
                    return runRequest;
                }
                if ("TaskRunRequest".equals(discriminatorValue)) {
                    runRequest = TaskRunRequest.fromJson(readerToUse.reset());
                    return runRequest;
                }
                if ("EncodedTaskRunRequest".equals(discriminatorValue)) {
                    runRequest = EncodedTaskRunRequest.fromJson(readerToUse.reset());
                    return runRequest;
                }
                runRequest = RunRequest.fromJsonKnownDiscriminator(readerToUse.reset());
                return runRequest;
            }
        });
    }

    static RunRequest fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (RunRequest)jsonReader.readObject(reader -> {
            RunRequest deserializedRunRequest = new RunRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedRunRequest.type = reader.getString();
                    continue;
                }
                if ("isArchiveEnabled".equals(fieldName)) {
                    deserializedRunRequest.isArchiveEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("agentPoolName".equals(fieldName)) {
                    deserializedRunRequest.agentPoolName = reader.getString();
                    continue;
                }
                if ("logTemplate".equals(fieldName)) {
                    deserializedRunRequest.logTemplate = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunRequest;
        });
    }
}

