/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.TokenCredentialsProperties;
import com.azure.resourcemanager.containerregistry.models.TokenStatus;
import java.io.IOException;

public final class TokenUpdateProperties
implements JsonSerializable<TokenUpdateProperties> {
    private String scopeMapId;
    private TokenStatus status;
    private TokenCredentialsProperties credentials;

    public String scopeMapId() {
        return this.scopeMapId;
    }

    public TokenUpdateProperties withScopeMapId(String scopeMapId) {
        this.scopeMapId = scopeMapId;
        return this;
    }

    public TokenStatus status() {
        return this.status;
    }

    public TokenUpdateProperties withStatus(TokenStatus status) {
        this.status = status;
        return this;
    }

    public TokenCredentialsProperties credentials() {
        return this.credentials;
    }

    public TokenUpdateProperties withCredentials(TokenCredentialsProperties credentials) {
        this.credentials = credentials;
        return this;
    }

    public void validate() {
        if (this.credentials() != null) {
            this.credentials().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scopeMapId", this.scopeMapId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("credentials", (JsonSerializable)this.credentials);
        return jsonWriter.writeEndObject();
    }

    public static TokenUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TokenUpdateProperties)jsonReader.readObject(reader -> {
            TokenUpdateProperties deserializedTokenUpdateProperties = new TokenUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scopeMapId".equals(fieldName)) {
                    deserializedTokenUpdateProperties.scopeMapId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedTokenUpdateProperties.status = TokenStatus.fromString(reader.getString());
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    deserializedTokenUpdateProperties.credentials = TokenCredentialsProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTokenUpdateProperties;
        });
    }
}

