/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.BaseImageDependency;
import com.azure.resourcemanager.containerregistry.models.SetValue;
import com.azure.resourcemanager.containerregistry.models.StepType;
import com.azure.resourcemanager.containerregistry.models.TaskStepProperties;
import java.io.IOException;
import java.util.List;

public final class FileTaskStep
extends TaskStepProperties {
    private StepType type = StepType.FILE_TASK;
    private String taskFilePath;
    private String valuesFilePath;
    private List<SetValue> values;
    private List<BaseImageDependency> baseImageDependencies;
    private static final ClientLogger LOGGER = new ClientLogger(FileTaskStep.class);

    @Override
    public StepType type() {
        return this.type;
    }

    public String taskFilePath() {
        return this.taskFilePath;
    }

    public FileTaskStep withTaskFilePath(String taskFilePath) {
        this.taskFilePath = taskFilePath;
        return this;
    }

    public String valuesFilePath() {
        return this.valuesFilePath;
    }

    public FileTaskStep withValuesFilePath(String valuesFilePath) {
        this.valuesFilePath = valuesFilePath;
        return this;
    }

    public List<SetValue> values() {
        return this.values;
    }

    public FileTaskStep withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    @Override
    public List<BaseImageDependency> baseImageDependencies() {
        return this.baseImageDependencies;
    }

    @Override
    public FileTaskStep withContextPath(String contextPath) {
        super.withContextPath(contextPath);
        return this;
    }

    @Override
    public FileTaskStep withContextAccessToken(String contextAccessToken) {
        super.withContextAccessToken(contextAccessToken);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.taskFilePath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property taskFilePath in model FileTaskStep"));
        }
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contextPath", this.contextPath());
        jsonWriter.writeStringField("contextAccessToken", this.contextAccessToken());
        jsonWriter.writeStringField("taskFilePath", this.taskFilePath);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("valuesFilePath", this.valuesFilePath);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FileTaskStep fromJson(JsonReader jsonReader) throws IOException {
        return (FileTaskStep)jsonReader.readObject(reader -> {
            FileTaskStep deserializedFileTaskStep = new FileTaskStep();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("baseImageDependencies".equals(fieldName)) {
                    List baseImageDependencies;
                    deserializedFileTaskStep.baseImageDependencies = baseImageDependencies = reader.readArray(reader1 -> BaseImageDependency.fromJson(reader1));
                    continue;
                }
                if ("contextPath".equals(fieldName)) {
                    deserializedFileTaskStep.withContextPath(reader.getString());
                    continue;
                }
                if ("contextAccessToken".equals(fieldName)) {
                    deserializedFileTaskStep.withContextAccessToken(reader.getString());
                    continue;
                }
                if ("taskFilePath".equals(fieldName)) {
                    deserializedFileTaskStep.taskFilePath = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFileTaskStep.type = StepType.fromString(reader.getString());
                    continue;
                }
                if ("valuesFilePath".equals(fieldName)) {
                    deserializedFileTaskStep.valuesFilePath = reader.getString();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedFileTaskStep.values = values = reader.readArray(reader1 -> SetValue.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileTaskStep;
        });
    }
}

