/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.resourcemanager.containerregistry.fluent.models.TaskPropertiesUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.azure.resourcemanager.containerregistry.models.Credentials;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.PlatformUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.TaskStatus;
import com.azure.resourcemanager.containerregistry.models.TaskStepUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.TriggerUpdateParameters;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class TaskUpdateParameters {
    @JsonProperty(value="identity")
    private IdentityProperties identity;
    @JsonProperty(value="properties")
    private TaskPropertiesUpdateParameters innerProperties;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    public IdentityProperties identity() {
        return this.identity;
    }

    public TaskUpdateParameters withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    private TaskPropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public TaskUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public TaskStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public TaskUpdateParameters withStatus(TaskStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public PlatformUpdateParameters platform() {
        return this.innerProperties() == null ? null : this.innerProperties().platform();
    }

    public TaskUpdateParameters withPlatform(PlatformUpdateParameters platform) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withPlatform(platform);
        return this;
    }

    public AgentProperties agentConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().agentConfiguration();
    }

    public TaskUpdateParameters withAgentConfiguration(AgentProperties agentConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withAgentConfiguration(agentConfiguration);
        return this;
    }

    public String agentPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().agentPoolName();
    }

    public TaskUpdateParameters withAgentPoolName(String agentPoolName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withAgentPoolName(agentPoolName);
        return this;
    }

    public Integer timeout() {
        return this.innerProperties() == null ? null : this.innerProperties().timeout();
    }

    public TaskUpdateParameters withTimeout(Integer timeout) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withTimeout(timeout);
        return this;
    }

    public TaskStepUpdateParameters step() {
        return this.innerProperties() == null ? null : this.innerProperties().step();
    }

    public TaskUpdateParameters withStep(TaskStepUpdateParameters step) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withStep(step);
        return this;
    }

    public TriggerUpdateParameters trigger() {
        return this.innerProperties() == null ? null : this.innerProperties().trigger();
    }

    public TaskUpdateParameters withTrigger(TriggerUpdateParameters trigger) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withTrigger(trigger);
        return this;
    }

    public Credentials credentials() {
        return this.innerProperties() == null ? null : this.innerProperties().credentials();
    }

    public TaskUpdateParameters withCredentials(Credentials credentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withCredentials(credentials);
        return this;
    }

    public String logTemplate() {
        return this.innerProperties() == null ? null : this.innerProperties().logTemplate();
    }

    public TaskUpdateParameters withLogTemplate(String logTemplate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskPropertiesUpdateParameters();
        }
        this.innerProperties().withLogTemplate(logTemplate);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

