/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.SourceTriggerEvent;
import com.azure.resourcemanager.containerregistry.models.SourceUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.TriggerStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class SourceTriggerUpdateParameters {
    @JsonProperty(value="sourceRepository")
    private SourceUpdateParameters sourceRepository;
    @JsonProperty(value="sourceTriggerEvents")
    private List<SourceTriggerEvent> sourceTriggerEvents;
    @JsonProperty(value="status")
    private TriggerStatus status;
    @JsonProperty(value="name", required=true)
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(SourceTriggerUpdateParameters.class);

    public SourceUpdateParameters sourceRepository() {
        return this.sourceRepository;
    }

    public SourceTriggerUpdateParameters withSourceRepository(SourceUpdateParameters sourceRepository) {
        this.sourceRepository = sourceRepository;
        return this;
    }

    public List<SourceTriggerEvent> sourceTriggerEvents() {
        return this.sourceTriggerEvents;
    }

    public SourceTriggerUpdateParameters withSourceTriggerEvents(List<SourceTriggerEvent> sourceTriggerEvents) {
        this.sourceTriggerEvents = sourceTriggerEvents;
        return this;
    }

    public TriggerStatus status() {
        return this.status;
    }

    public SourceTriggerUpdateParameters withStatus(TriggerStatus status) {
        this.status = status;
        return this;
    }

    public String name() {
        return this.name;
    }

    public SourceTriggerUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.sourceRepository() != null) {
            this.sourceRepository().validate();
        }
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model SourceTriggerUpdateParameters"));
        }
    }
}

