/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.azure.resourcemanager.containerregistry.fluent.ContainerRegistryManagementClient;
import com.azure.resourcemanager.containerregistry.fluent.RegistriesClient;
import com.azure.resourcemanager.containerregistry.fluent.models.RegistryInner;
import com.azure.resourcemanager.containerregistry.fluent.models.RegistryListCredentialsResultInner;
import com.azure.resourcemanager.containerregistry.fluent.models.RegistryNameStatusInner;
import com.azure.resourcemanager.containerregistry.fluent.models.RegistryUsageListResultInner;
import com.azure.resourcemanager.containerregistry.fluent.models.SourceUploadDefinitionInner;
import com.azure.resourcemanager.containerregistry.implementation.CheckNameAvailabilityResultImpl;
import com.azure.resourcemanager.containerregistry.implementation.RegistriesWebhooksClientImpl;
import com.azure.resourcemanager.containerregistry.implementation.RegistryCredentialsImpl;
import com.azure.resourcemanager.containerregistry.implementation.RegistryImpl;
import com.azure.resourcemanager.containerregistry.implementation.SourceUploadDefinitionImpl;
import com.azure.resourcemanager.containerregistry.models.AccessKeyType;
import com.azure.resourcemanager.containerregistry.models.CheckNameAvailabilityResult;
import com.azure.resourcemanager.containerregistry.models.PasswordName;
import com.azure.resourcemanager.containerregistry.models.Registries;
import com.azure.resourcemanager.containerregistry.models.Registry;
import com.azure.resourcemanager.containerregistry.models.RegistryCredentials;
import com.azure.resourcemanager.containerregistry.models.RegistryUsage;
import com.azure.resourcemanager.containerregistry.models.SourceUploadDefinition;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.storage.StorageManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import reactor.core.publisher.Mono;

public class RegistriesImpl
extends GroupableResourcesImpl<Registry, RegistryImpl, RegistryInner, RegistriesClient, ContainerRegistryManager>
implements Registries {
    private final StorageManager storageManager;

    public RegistriesImpl(ContainerRegistryManager manager, StorageManager storageManager) {
        super((Object)((ContainerRegistryManagementClient)manager.serviceClient()).getRegistries(), (Manager)manager);
        this.storageManager = storageManager;
    }

    public PagedIterable<Registry> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<Registry> listAsync() {
        return PagedConverter.mapPage(((RegistriesClient)this.inner()).listAsync(), inner -> new RegistryImpl(inner.name(), (RegistryInner)((Object)inner), (ContainerRegistryManager)this.manager(), this.storageManager));
    }

    public PagedFlux<Registry> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((RegistriesClient)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    public PagedIterable<Registry> listByResourceGroup(String groupName) {
        return this.wrapList(((RegistriesClient)this.inner()).listByResourceGroup(groupName));
    }

    protected Mono<RegistryInner> getInnerAsync(String resourceGroupName, String name) {
        return ((RegistriesClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    public RegistryImpl define(String name) {
        return this.wrapModel(name);
    }

    protected Mono<Void> deleteInnerAsync(String groupName, String name) {
        return ((RegistriesClient)this.inner()).deleteAsync(groupName, name);
    }

    protected RegistryImpl wrapModel(String name) {
        return new RegistryImpl(name, new RegistryInner(), (ContainerRegistryManager)this.manager(), this.storageManager);
    }

    protected RegistryImpl wrapModel(RegistryInner containerServiceInner) {
        if (containerServiceInner == null) {
            return null;
        }
        return new RegistryImpl(containerServiceInner.name(), containerServiceInner, (ContainerRegistryManager)this.manager(), this.storageManager);
    }

    @Override
    public RegistryCredentials getCredentials(String resourceGroupName, String registryName) {
        return new RegistryCredentialsImpl(((RegistriesClient)this.inner()).listCredentials(resourceGroupName, registryName));
    }

    @Override
    public Mono<RegistryCredentials> getCredentialsAsync(String resourceGroupName, String registryName) {
        return ((RegistriesClient)this.inner()).listCredentialsAsync(resourceGroupName, registryName).map(registryListCredentialsResultInner -> new RegistryCredentialsImpl((RegistryListCredentialsResultInner)registryListCredentialsResultInner));
    }

    @Override
    public RegistryCredentials regenerateCredential(String resourceGroupName, String registryName, AccessKeyType accessKeyType) {
        return new RegistryCredentialsImpl(((RegistriesClient)this.inner()).regenerateCredential(resourceGroupName, registryName, PasswordName.fromString(accessKeyType.toString())));
    }

    @Override
    public Mono<RegistryCredentials> regenerateCredentialAsync(String resourceGroupName, String registryName, AccessKeyType accessKeyType) {
        return ((RegistriesClient)this.inner()).regenerateCredentialAsync(resourceGroupName, registryName, PasswordName.fromString(accessKeyType.toString())).map(RegistryCredentialsImpl::new);
    }

    @Override
    public Collection<RegistryUsage> listQuotaUsages(String resourceGroupName, String registryName) {
        RegistryUsageListResultInner resultInner = ((RegistriesClient)this.inner()).listUsages(resourceGroupName, registryName);
        return Collections.unmodifiableList(resultInner != null && resultInner.value() != null ? resultInner.value() : new ArrayList());
    }

    @Override
    public PagedFlux<RegistryUsage> listQuotaUsagesAsync(String resourceGroupName, String registryName) {
        return PagedConverter.convertListToPagedFlux((Mono)((RegistriesClient)this.inner()).listUsagesWithResponseAsync(resourceGroupName, registryName).map(r -> new SimpleResponse(r.getRequest(), r.getStatusCode(), r.getHeaders(), ((RegistryUsageListResultInner)r.getValue()).value() == null ? Collections.emptyList() : ((RegistryUsageListResultInner)r.getValue()).value())));
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String name) {
        return new CheckNameAvailabilityResultImpl(((RegistriesClient)this.inner()).checkNameAvailability(name));
    }

    @Override
    public Mono<CheckNameAvailabilityResult> checkNameAvailabilityAsync(String name) {
        return ((RegistriesClient)this.inner()).checkNameAvailabilityAsync(name).map(registryNameStatusInner -> new CheckNameAvailabilityResultImpl((RegistryNameStatusInner)registryNameStatusInner));
    }

    @Override
    public SourceUploadDefinition getBuildSourceUploadUrl(String rgName, String acrName) {
        return (SourceUploadDefinition)this.getBuildSourceUploadUrlAsync(rgName, acrName).block();
    }

    @Override
    public Mono<SourceUploadDefinition> getBuildSourceUploadUrlAsync(String rgName, String acrName) {
        return ((ContainerRegistryManagementClient)((ContainerRegistryManager)this.manager()).serviceClient()).getRegistries().getBuildSourceUploadUrlAsync(rgName, acrName).map(sourceUploadDefinitionInner -> new SourceUploadDefinitionImpl((SourceUploadDefinitionInner)sourceUploadDefinitionInner));
    }

    @Override
    public Registries.WebhooksClient webhooks() {
        return new RegistriesWebhooksClientImpl((ContainerRegistryManager)this.manager(), null);
    }
}

