/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.TokenCredentialsProperties;
import com.azure.resourcemanager.containerregistry.models.TokenStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class TokenProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TokenProperties.class);
    @JsonProperty(value="creationDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime creationDate;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="scopeMapId")
    private String scopeMapId;
    @JsonProperty(value="credentials")
    private TokenCredentialsProperties credentials;
    @JsonProperty(value="status")
    private TokenStatus status;

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String scopeMapId() {
        return this.scopeMapId;
    }

    public TokenProperties withScopeMapId(String scopeMapId) {
        this.scopeMapId = scopeMapId;
        return this;
    }

    public TokenCredentialsProperties credentials() {
        return this.credentials;
    }

    public TokenProperties withCredentials(TokenCredentialsProperties credentials) {
        this.credentials = credentials;
        return this;
    }

    public TokenStatus status() {
        return this.status;
    }

    public TokenProperties withStatus(TokenStatus status) {
        this.status = status;
        return this;
    }

    public void validate() {
        if (this.credentials() != null) {
            this.credentials().validate();
        }
    }
}

