/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.http.rest.PagedFlux;
import com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.azure.resourcemanager.containerregistry.fluent.models.RegistryInner;
import com.azure.resourcemanager.containerregistry.models.AccessKeyType;
import com.azure.resourcemanager.containerregistry.models.RegistryCredentials;
import com.azure.resourcemanager.containerregistry.models.RegistryTaskRun;
import com.azure.resourcemanager.containerregistry.models.RegistryUsage;
import com.azure.resourcemanager.containerregistry.models.Sku;
import com.azure.resourcemanager.containerregistry.models.SourceUploadDefinition;
import com.azure.resourcemanager.containerregistry.models.Webhook;
import com.azure.resourcemanager.containerregistry.models.WebhookOperations;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.storage.models.StorageAccount;
import java.time.OffsetDateTime;
import java.util.Collection;
import reactor.core.publisher.Mono;

public interface Registry
extends GroupableResource<ContainerRegistryManager, RegistryInner>,
Refreshable<Registry>,
Updatable<Update> {
    public Sku sku();

    public String loginServerUrl();

    public OffsetDateTime creationDate();

    public boolean adminUserEnabled();

    public String storageAccountName();

    public String storageAccountId();

    public RegistryCredentials getCredentials();

    public Mono<RegistryCredentials> getCredentialsAsync();

    public RegistryCredentials regenerateCredential(AccessKeyType var1);

    public Mono<RegistryCredentials> regenerateCredentialAsync(AccessKeyType var1);

    public Collection<RegistryUsage> listQuotaUsages();

    public PagedFlux<RegistryUsage> listQuotaUsagesAsync();

    public SourceUploadDefinition getBuildSourceUploadUrl();

    public Mono<SourceUploadDefinition> getBuildSourceUploadUrlAsync();

    public WebhookOperations webhooks();

    public RegistryTaskRun.DefinitionStages.BlankFromRegistry scheduleRun();

    public static interface UpdateStages {

        public static interface WithWebhook {
            public Webhook.UpdateDefinitionStages.Blank<Update> defineWebhook(String var1);

            public Update withoutWebhook(String var1);

            public Webhook.UpdateResourceStages.Blank<Update> updateWebhook(String var1);
        }

        public static interface WithSku {
            public Update withBasicSku();

            public Update withStandardSku();

            public Update withPremiumSku();
        }

        public static interface WithAdminUserEnabled {
            public Update withRegistryNameAsAdminUser();

            public Update withoutRegistryNameAsAdminUser();
        }
    }

    public static interface Update
    extends Resource.UpdateWithTags<Update>,
    Appliable<Registry>,
    UpdateStages.WithAdminUserEnabled,
    UpdateStages.WithSku,
    UpdateStages.WithWebhook {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Registry>,
        WithAdminUserEnabled,
        WithWebhook,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithWebhook {
            public Webhook.DefinitionStages.Blank<WithCreate> defineWebhook(String var1);
        }

        public static interface WithAdminUserEnabled {
            public WithCreate withRegistryNameAsAdminUser();
        }

        public static interface WithStorageAccount {
            public WithCreate withExistingStorageAccount(StorageAccount var1);

            public WithCreate withExistingStorageAccount(String var1);

            public WithCreate withNewStorageAccount(String var1);

            public WithCreate withNewStorageAccount(Creatable<StorageAccount> var1);
        }

        public static interface WithSku {
            public WithStorageAccount withClassicSku();

            public WithCreate withBasicSku();

            public WithCreate withStandardSku();

            public WithCreate withPremiumSku();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithSku> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithStorageAccount,
    DefinitionStages.WithCreate {
    }
}

