/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.SetValue;
import com.azure.resourcemanager.containerregistry.models.TaskStepUpdateParameters;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="FileTask")
public final class FileTaskStepUpdateParameters
extends TaskStepUpdateParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(FileTaskStepUpdateParameters.class);
    @JsonProperty(value="taskFilePath")
    private String taskFilePath;
    @JsonProperty(value="valuesFilePath")
    private String valuesFilePath;
    @JsonProperty(value="values")
    private List<SetValue> values;

    public String taskFilePath() {
        return this.taskFilePath;
    }

    public FileTaskStepUpdateParameters withTaskFilePath(String taskFilePath) {
        this.taskFilePath = taskFilePath;
        return this;
    }

    public String valuesFilePath() {
        return this.valuesFilePath;
    }

    public FileTaskStepUpdateParameters withValuesFilePath(String valuesFilePath) {
        this.valuesFilePath = valuesFilePath;
        return this;
    }

    public List<SetValue> values() {
        return this.values;
    }

    public FileTaskStepUpdateParameters withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
    }
}

