/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.azure.resourcemanager.containerregistry.models.Credentials;
import com.azure.resourcemanager.containerregistry.models.PlatformProperties;
import com.azure.resourcemanager.containerregistry.models.RunRequest;
import com.azure.resourcemanager.containerregistry.models.SetValue;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="EncodedTaskRunRequest")
public final class EncodedTaskRunRequest
extends RunRequest {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EncodedTaskRunRequest.class);
    @JsonProperty(value="encodedTaskContent", required=true)
    private String encodedTaskContent;
    @JsonProperty(value="encodedValuesContent")
    private String encodedValuesContent;
    @JsonProperty(value="values")
    private List<SetValue> values;
    @JsonProperty(value="timeout")
    private Integer timeout;
    @JsonProperty(value="platform", required=true)
    private PlatformProperties platform;
    @JsonProperty(value="agentConfiguration")
    private AgentProperties agentConfiguration;
    @JsonProperty(value="sourceLocation")
    private String sourceLocation;
    @JsonProperty(value="credentials")
    private Credentials credentials;

    public String encodedTaskContent() {
        return this.encodedTaskContent;
    }

    public EncodedTaskRunRequest withEncodedTaskContent(String encodedTaskContent) {
        this.encodedTaskContent = encodedTaskContent;
        return this;
    }

    public String encodedValuesContent() {
        return this.encodedValuesContent;
    }

    public EncodedTaskRunRequest withEncodedValuesContent(String encodedValuesContent) {
        this.encodedValuesContent = encodedValuesContent;
        return this;
    }

    public List<SetValue> values() {
        return this.values;
    }

    public EncodedTaskRunRequest withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public EncodedTaskRunRequest withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public PlatformProperties platform() {
        return this.platform;
    }

    public EncodedTaskRunRequest withPlatform(PlatformProperties platform) {
        this.platform = platform;
        return this;
    }

    public AgentProperties agentConfiguration() {
        return this.agentConfiguration;
    }

    public EncodedTaskRunRequest withAgentConfiguration(AgentProperties agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public String sourceLocation() {
        return this.sourceLocation;
    }

    public EncodedTaskRunRequest withSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
        return this;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public EncodedTaskRunRequest withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.encodedTaskContent() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property encodedTaskContent in model EncodedTaskRunRequest"));
        }
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
        if (this.platform() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property platform in model EncodedTaskRunRequest"));
        }
        this.platform().validate();
        if (this.agentConfiguration() != null) {
            this.agentConfiguration().validate();
        }
        if (this.credentials() != null) {
            this.credentials().validate();
        }
    }
}

