/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.Argument;
import com.azure.resourcemanager.containerregistry.models.TaskStepProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="Docker")
public final class DockerTaskStep
extends TaskStepProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DockerTaskStep.class);
    @JsonProperty(value="imageNames")
    private List<String> imageNames;
    @JsonProperty(value="isPushEnabled")
    private Boolean isPushEnabled;
    @JsonProperty(value="noCache")
    private Boolean noCache;
    @JsonProperty(value="dockerFilePath", required=true)
    private String dockerFilePath;
    @JsonProperty(value="target")
    private String target;
    @JsonProperty(value="arguments")
    private List<Argument> arguments;

    public List<String> imageNames() {
        return this.imageNames;
    }

    public DockerTaskStep withImageNames(List<String> imageNames) {
        this.imageNames = imageNames;
        return this;
    }

    public Boolean isPushEnabled() {
        return this.isPushEnabled;
    }

    public DockerTaskStep withIsPushEnabled(Boolean isPushEnabled) {
        this.isPushEnabled = isPushEnabled;
        return this;
    }

    public Boolean noCache() {
        return this.noCache;
    }

    public DockerTaskStep withNoCache(Boolean noCache) {
        this.noCache = noCache;
        return this;
    }

    public String dockerFilePath() {
        return this.dockerFilePath;
    }

    public DockerTaskStep withDockerFilePath(String dockerFilePath) {
        this.dockerFilePath = dockerFilePath;
        return this;
    }

    public String target() {
        return this.target;
    }

    public DockerTaskStep withTarget(String target) {
        this.target = target;
        return this;
    }

    public List<Argument> arguments() {
        return this.arguments;
    }

    public DockerTaskStep withArguments(List<Argument> arguments) {
        this.arguments = arguments;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.dockerFilePath() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property dockerFilePath in model DockerTaskStep"));
        }
        if (this.arguments() != null) {
            this.arguments().forEach(e -> e.validate());
        }
    }
}

