/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerregistry.fluent.WebhooksClient;
import com.azure.resourcemanager.containerregistry.fluent.models.CallbackConfigInner;
import com.azure.resourcemanager.containerregistry.fluent.models.EventInfoInner;
import com.azure.resourcemanager.containerregistry.fluent.models.EventInner;
import com.azure.resourcemanager.containerregistry.fluent.models.WebhookInner;
import com.azure.resourcemanager.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.azure.resourcemanager.containerregistry.models.EventListResult;
import com.azure.resourcemanager.containerregistry.models.WebhookCreateParameters;
import com.azure.resourcemanager.containerregistry.models.WebhookListResult;
import com.azure.resourcemanager.containerregistry.models.WebhookUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class WebhooksClientImpl
implements WebhooksClient {
    private final ClientLogger logger = new ClientLogger(WebhooksClientImpl.class);
    private final WebhooksService service;
    private final ContainerRegistryManagementClientImpl client;

    WebhooksClientImpl(ContainerRegistryManagementClientImpl client) {
        this.service = (WebhooksService)RestProxy.create(WebhooksService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<WebhookInner>> getWithResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, webhookName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<WebhookInner>> getWithResponseAsync(String resourceGroupName, String registryName, String webhookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, webhookName, context);
    }

    @Override
    public Mono<WebhookInner> getAsync(String resourceGroupName, String registryName, String webhookName) {
        return this.getWithResponseAsync(resourceGroupName, registryName, webhookName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((WebhookInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public WebhookInner get(String resourceGroupName, String registryName, String webhookName) {
        return (WebhookInner)((Object)this.getAsync(resourceGroupName, registryName, webhookName).block());
    }

    @Override
    public Response<WebhookInner> getWithResponse(String resourceGroupName, String registryName, String webhookName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, registryName, webhookName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        if (webhookCreateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookCreateParameters is required and cannot be null."));
        }
        webhookCreateParameters.validate();
        String apiVersion = "2019-05-01";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, webhookName, webhookCreateParameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        if (webhookCreateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookCreateParameters is required and cannot be null."));
        }
        webhookCreateParameters.validate();
        String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, webhookName, webhookCreateParameters, context);
    }

    @Override
    public PollerFlux<PollResult<WebhookInner>, WebhookInner> beginCreateAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)WebhookInner.class), (Type)((Object)WebhookInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<WebhookInner>, WebhookInner> beginCreateAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)WebhookInner.class), (Type)((Object)WebhookInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<WebhookInner>, WebhookInner> beginCreate(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters) {
        return this.beginCreateAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<WebhookInner>, WebhookInner> beginCreate(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters, context).getSyncPoller();
    }

    @Override
    public Mono<WebhookInner> createAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters) {
        return this.beginCreateAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<WebhookInner> createAsync(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public WebhookInner create(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters) {
        return (WebhookInner)((Object)this.createAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters).block());
    }

    @Override
    public WebhookInner create(String resourceGroupName, String registryName, String webhookName, WebhookCreateParameters webhookCreateParameters, Context context) {
        return (WebhookInner)((Object)this.createAsync(resourceGroupName, registryName, webhookName, webhookCreateParameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, webhookName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String registryName, String webhookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, webhookName, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName, String webhookName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, registryName, webhookName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String registryName, String webhookName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, registryName, webhookName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName, String webhookName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, webhookName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String registryName, String webhookName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, webhookName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String registryName, String webhookName) {
        return this.beginDeleteAsync(resourceGroupName, registryName, webhookName).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String registryName, String webhookName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, registryName, webhookName, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String registryName, String webhookName) {
        this.deleteAsync(resourceGroupName, registryName, webhookName).block();
    }

    @Override
    public void delete(String resourceGroupName, String registryName, String webhookName, Context context) {
        this.deleteAsync(resourceGroupName, registryName, webhookName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        if (webhookUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookUpdateParameters is required and cannot be null."));
        }
        webhookUpdateParameters.validate();
        String apiVersion = "2019-05-01";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, webhookName, webhookUpdateParameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        if (webhookUpdateParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookUpdateParameters is required and cannot be null."));
        }
        webhookUpdateParameters.validate();
        String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, webhookName, webhookUpdateParameters, context);
    }

    @Override
    public PollerFlux<PollResult<WebhookInner>, WebhookInner> beginUpdateAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)WebhookInner.class), (Type)((Object)WebhookInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<WebhookInner>, WebhookInner> beginUpdateAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)WebhookInner.class), (Type)((Object)WebhookInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<WebhookInner>, WebhookInner> beginUpdate(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<WebhookInner>, WebhookInner> beginUpdate(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters, context).getSyncPoller();
    }

    @Override
    public Mono<WebhookInner> updateAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<WebhookInner> updateAsync(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters, context).last().flatMap(arg_0 -> ((ContainerRegistryManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public WebhookInner update(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters) {
        return (WebhookInner)((Object)this.updateAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters).block());
    }

    @Override
    public WebhookInner update(String resourceGroupName, String registryName, String webhookName, WebhookUpdateParameters webhookUpdateParameters, Context context) {
        return (WebhookInner)((Object)this.updateAsync(resourceGroupName, registryName, webhookName, webhookUpdateParameters, context).block());
    }

    private Mono<PagedResponse<WebhookInner>> listSinglePageAsync(String resourceGroupName, String registryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebhookListResult)res.getValue()).value(), ((WebhookListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<WebhookInner>> listSinglePageAsync(String resourceGroupName, String registryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebhookListResult)res.getValue()).value(), ((WebhookListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<WebhookInner> listAsync(String resourceGroupName, String registryName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<WebhookInner> listAsync(String resourceGroupName, String registryName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, registryName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<WebhookInner> list(String resourceGroupName, String registryName) {
        return new PagedIterable(this.listAsync(resourceGroupName, registryName));
    }

    @Override
    public PagedIterable<WebhookInner> list(String resourceGroupName, String registryName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, registryName, context));
    }

    @Override
    public Mono<Response<EventInfoInner>> pingWithResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        return FluxUtil.withContext(context -> this.service.ping(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, webhookName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<EventInfoInner>> pingWithResponseAsync(String resourceGroupName, String registryName, String webhookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return this.service.ping(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, webhookName, context);
    }

    @Override
    public Mono<EventInfoInner> pingAsync(String resourceGroupName, String registryName, String webhookName) {
        return this.pingWithResponseAsync(resourceGroupName, registryName, webhookName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((EventInfoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public EventInfoInner ping(String resourceGroupName, String registryName, String webhookName) {
        return (EventInfoInner)this.pingAsync(resourceGroupName, registryName, webhookName).block();
    }

    @Override
    public Response<EventInfoInner> pingWithResponse(String resourceGroupName, String registryName, String webhookName, Context context) {
        return (Response)this.pingWithResponseAsync(resourceGroupName, registryName, webhookName, context).block();
    }

    @Override
    public Mono<Response<CallbackConfigInner>> getCallbackConfigWithResponseAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        return FluxUtil.withContext(context -> this.service.getCallbackConfig(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, webhookName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<CallbackConfigInner>> getCallbackConfigWithResponseAsync(String resourceGroupName, String registryName, String webhookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return this.service.getCallbackConfig(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, webhookName, context);
    }

    @Override
    public Mono<CallbackConfigInner> getCallbackConfigAsync(String resourceGroupName, String registryName, String webhookName) {
        return this.getCallbackConfigWithResponseAsync(resourceGroupName, registryName, webhookName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CallbackConfigInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public CallbackConfigInner getCallbackConfig(String resourceGroupName, String registryName, String webhookName) {
        return (CallbackConfigInner)this.getCallbackConfigAsync(resourceGroupName, registryName, webhookName).block();
    }

    @Override
    public Response<CallbackConfigInner> getCallbackConfigWithResponse(String resourceGroupName, String registryName, String webhookName, Context context) {
        return (Response)this.getCallbackConfigWithResponseAsync(resourceGroupName, registryName, webhookName, context).block();
    }

    private Mono<PagedResponse<EventInner>> listEventsSinglePageAsync(String resourceGroupName, String registryName, String webhookName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        return FluxUtil.withContext(context -> this.service.listEvents(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, webhookName, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventListResult)res.getValue()).value(), ((EventListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<EventInner>> listEventsSinglePageAsync(String resourceGroupName, String registryName, String webhookName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (registryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter registryName is required and cannot be null."));
        }
        if (webhookName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webhookName is required and cannot be null."));
        }
        String apiVersion = "2019-05-01";
        context = this.client.mergeContext(context);
        return this.service.listEvents(this.client.getEndpoint(), "2019-05-01", this.client.getSubscriptionId(), resourceGroupName, registryName, webhookName, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventListResult)res.getValue()).value(), ((EventListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<EventInner> listEventsAsync(String resourceGroupName, String registryName, String webhookName) {
        return new PagedFlux(() -> this.listEventsSinglePageAsync(resourceGroupName, registryName, webhookName), nextLink -> this.listEventsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<EventInner> listEventsAsync(String resourceGroupName, String registryName, String webhookName, Context context) {
        return new PagedFlux(() -> this.listEventsSinglePageAsync(resourceGroupName, registryName, webhookName, context), nextLink -> this.listEventsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<EventInner> listEvents(String resourceGroupName, String registryName, String webhookName) {
        return new PagedIterable(this.listEventsAsync(resourceGroupName, registryName, webhookName));
    }

    @Override
    public PagedIterable<EventInner> listEvents(String resourceGroupName, String registryName, String webhookName, Context context) {
        return new PagedIterable(this.listEventsAsync(resourceGroupName, registryName, webhookName, context));
    }

    private Mono<PagedResponse<WebhookInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebhookListResult)res.getValue()).value(), ((WebhookListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<WebhookInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebhookListResult)res.getValue()).value(), ((WebhookListResult)res.getValue()).nextLink(), null));
    }

    private Mono<PagedResponse<EventInner>> listEventsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listEventsNext(nextLink, this.client.getEndpoint(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventListResult)res.getValue()).value(), ((EventListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<EventInner>> listEventsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listEventsNext(nextLink, this.client.getEndpoint(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventListResult)res.getValue()).value(), ((EventListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerRegistryMan")
    private static interface WebhooksService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WebhookInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="webhookName") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="webhookName") String var6, @BodyParam(value="application/json") WebhookCreateParameters var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="webhookName") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="webhookName") String var6, @BodyParam(value="application/json") WebhookUpdateParameters var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WebhookListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}/ping")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventInfoInner>> ping(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="webhookName") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}/getCallbackConfig")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CallbackConfigInner>> getCallbackConfig(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="webhookName") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}/listEvents")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventListResult>> listEvents(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="registryName") String var5, @PathParam(value="webhookName") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<WebhookListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, Context var3);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<EventListResult>> listEventsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, Context var3);
    }
}

