/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.azure.resourcemanager.containerregistry.models.ImageDescriptor;
import com.azure.resourcemanager.containerregistry.models.ImageUpdateTrigger;
import com.azure.resourcemanager.containerregistry.models.PlatformProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.RunStatus;
import com.azure.resourcemanager.containerregistry.models.RunType;
import com.azure.resourcemanager.containerregistry.models.SourceTriggerDescriptor;
import com.azure.resourcemanager.containerregistry.models.TimerTriggerDescriptor;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

@JsonFlatten
public class RunInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RunInner.class);
    @JsonProperty(value="properties.runId")
    private String runId;
    @JsonProperty(value="properties.status")
    private RunStatus status;
    @JsonProperty(value="properties.lastUpdatedTime")
    private OffsetDateTime lastUpdatedTime;
    @JsonProperty(value="properties.runType")
    private RunType runType;
    @JsonProperty(value="properties.createTime")
    private OffsetDateTime createTime;
    @JsonProperty(value="properties.startTime")
    private OffsetDateTime startTime;
    @JsonProperty(value="properties.finishTime")
    private OffsetDateTime finishTime;
    @JsonProperty(value="properties.outputImages")
    private List<ImageDescriptor> outputImages;
    @JsonProperty(value="properties.task")
    private String task;
    @JsonProperty(value="properties.imageUpdateTrigger")
    private ImageUpdateTrigger imageUpdateTrigger;
    @JsonProperty(value="properties.sourceTrigger")
    private SourceTriggerDescriptor sourceTrigger;
    @JsonProperty(value="properties.platform")
    private PlatformProperties platform;
    @JsonProperty(value="properties.agentConfiguration")
    private AgentProperties agentConfiguration;
    @JsonProperty(value="properties.sourceRegistryAuth")
    private String sourceRegistryAuth;
    @JsonProperty(value="properties.customRegistries")
    private List<String> customRegistries;
    @JsonProperty(value="properties.runErrorMessage", access=JsonProperty.Access.WRITE_ONLY)
    private String runErrorMessage;
    @JsonProperty(value="properties.provisioningState")
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.isArchiveEnabled")
    private Boolean isArchiveEnabled;
    @JsonProperty(value="properties.timerTrigger")
    private TimerTriggerDescriptor timerTrigger;

    public String runId() {
        return this.runId;
    }

    public RunInner withRunId(String runId) {
        this.runId = runId;
        return this;
    }

    public RunStatus status() {
        return this.status;
    }

    public RunInner withStatus(RunStatus status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public RunInner withLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    public RunType runType() {
        return this.runType;
    }

    public RunInner withRunType(RunType runType) {
        this.runType = runType;
        return this;
    }

    public OffsetDateTime createTime() {
        return this.createTime;
    }

    public RunInner withCreateTime(OffsetDateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public RunInner withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime finishTime() {
        return this.finishTime;
    }

    public RunInner withFinishTime(OffsetDateTime finishTime) {
        this.finishTime = finishTime;
        return this;
    }

    public List<ImageDescriptor> outputImages() {
        return this.outputImages;
    }

    public RunInner withOutputImages(List<ImageDescriptor> outputImages) {
        this.outputImages = outputImages;
        return this;
    }

    public String task() {
        return this.task;
    }

    public RunInner withTask(String task) {
        this.task = task;
        return this;
    }

    public ImageUpdateTrigger imageUpdateTrigger() {
        return this.imageUpdateTrigger;
    }

    public RunInner withImageUpdateTrigger(ImageUpdateTrigger imageUpdateTrigger) {
        this.imageUpdateTrigger = imageUpdateTrigger;
        return this;
    }

    public SourceTriggerDescriptor sourceTrigger() {
        return this.sourceTrigger;
    }

    public RunInner withSourceTrigger(SourceTriggerDescriptor sourceTrigger) {
        this.sourceTrigger = sourceTrigger;
        return this;
    }

    public PlatformProperties platform() {
        return this.platform;
    }

    public RunInner withPlatform(PlatformProperties platform) {
        this.platform = platform;
        return this;
    }

    public AgentProperties agentConfiguration() {
        return this.agentConfiguration;
    }

    public RunInner withAgentConfiguration(AgentProperties agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public String sourceRegistryAuth() {
        return this.sourceRegistryAuth;
    }

    public RunInner withSourceRegistryAuth(String sourceRegistryAuth) {
        this.sourceRegistryAuth = sourceRegistryAuth;
        return this;
    }

    public List<String> customRegistries() {
        return this.customRegistries;
    }

    public RunInner withCustomRegistries(List<String> customRegistries) {
        this.customRegistries = customRegistries;
        return this;
    }

    public String runErrorMessage() {
        return this.runErrorMessage;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public RunInner withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public Boolean isArchiveEnabled() {
        return this.isArchiveEnabled;
    }

    public RunInner withIsArchiveEnabled(Boolean isArchiveEnabled) {
        this.isArchiveEnabled = isArchiveEnabled;
        return this;
    }

    public TimerTriggerDescriptor timerTrigger() {
        return this.timerTrigger;
    }

    public RunInner withTimerTrigger(TimerTriggerDescriptor timerTrigger) {
        this.timerTrigger = timerTrigger;
        return this;
    }

    public void validate() {
        if (this.outputImages() != null) {
            this.outputImages().forEach(e -> e.validate());
        }
        if (this.imageUpdateTrigger() != null) {
            this.imageUpdateTrigger().validate();
        }
        if (this.sourceTrigger() != null) {
            this.sourceTrigger().validate();
        }
        if (this.platform() != null) {
            this.platform().validate();
        }
        if (this.agentConfiguration() != null) {
            this.agentConfiguration().validate();
        }
        if (this.timerTrigger() != null) {
            this.timerTrigger().validate();
        }
    }
}

