/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerinstance.fluent.ContainersClient;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerExecResponseInner;
import com.azure.resourcemanager.containerinstance.fluent.models.LogsInner;
import com.azure.resourcemanager.containerinstance.implementation.ContainerInstanceManagementClientImpl;
import com.azure.resourcemanager.containerinstance.models.ContainerExecRequest;
import reactor.core.publisher.Mono;

public final class ContainersClientImpl
implements ContainersClient {
    private final ClientLogger logger = new ClientLogger(ContainersClientImpl.class);
    private final ContainersService service;
    private final ContainerInstanceManagementClientImpl client;

    ContainersClientImpl(ContainerInstanceManagementClientImpl client) {
        this.service = (ContainersService)RestProxy.create(ContainersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<LogsInner>> listLogsWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName, Integer tail) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listLogs(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, tail, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<LogsInner>> listLogsWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName, Integer tail, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listLogs(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, tail, context);
    }

    @Override
    public Mono<LogsInner> listLogsAsync(String resourceGroupName, String containerGroupName, String containerName, Integer tail) {
        return this.listLogsWithResponseAsync(resourceGroupName, containerGroupName, containerName, tail).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LogsInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<LogsInner> listLogsAsync(String resourceGroupName, String containerGroupName, String containerName) {
        Integer tail = null;
        return this.listLogsWithResponseAsync(resourceGroupName, containerGroupName, containerName, tail).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LogsInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public LogsInner listLogs(String resourceGroupName, String containerGroupName, String containerName) {
        Integer tail = null;
        return (LogsInner)this.listLogsAsync(resourceGroupName, containerGroupName, containerName, tail).block();
    }

    @Override
    public Response<LogsInner> listLogsWithResponse(String resourceGroupName, String containerGroupName, String containerName, Integer tail, Context context) {
        return (Response)this.listLogsWithResponseAsync(resourceGroupName, containerGroupName, containerName, tail, context).block();
    }

    @Override
    public Mono<Response<ContainerExecResponseInner>> executeCommandWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (containerExecRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerExecRequest is required and cannot be null."));
        }
        containerExecRequest.validate();
        return FluxUtil.withContext(context -> this.service.executeCommand(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, containerExecRequest, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ContainerExecResponseInner>> executeCommandWithResponseAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (containerExecRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter containerExecRequest is required and cannot be null."));
        }
        containerExecRequest.validate();
        context = this.client.mergeContext(context);
        return this.service.executeCommand(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, containerName, containerExecRequest, context);
    }

    @Override
    public Mono<ContainerExecResponseInner> executeCommandAsync(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest) {
        return this.executeCommandWithResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ContainerExecResponseInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ContainerExecResponseInner executeCommand(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest) {
        return (ContainerExecResponseInner)this.executeCommandAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest).block();
    }

    @Override
    public Response<ContainerExecResponseInner> executeCommandWithResponse(String resourceGroupName, String containerGroupName, String containerName, ContainerExecRequest containerExecRequest, Context context) {
        return (Response)this.executeCommandWithResponseAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ContainerInstanceMan")
    private static interface ContainersService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/logs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LogsInner>> listLogs(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="containerGroupName") String var5, @PathParam(value="containerName") String var6, @QueryParam(value="tail") Integer var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/containers/{containerName}/exec")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ContainerExecResponseInner>> executeCommand(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="containerGroupName") String var5, @PathParam(value="containerName") String var6, @BodyParam(value="application/json") ContainerExecRequest var7, Context var8);
    }
}

