/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ImageRegistryCredential {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ImageRegistryCredential.class);
    @JsonProperty(value="server", required=true)
    private String server;
    @JsonProperty(value="username", required=true)
    private String username;
    @JsonProperty(value="password")
    private String password;
    @JsonProperty(value="identity")
    private String identity;
    @JsonProperty(value="identityUrl")
    private String identityUrl;

    public String server() {
        return this.server;
    }

    public ImageRegistryCredential withServer(String server) {
        this.server = server;
        return this;
    }

    public String username() {
        return this.username;
    }

    public ImageRegistryCredential withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public ImageRegistryCredential withPassword(String password) {
        this.password = password;
        return this;
    }

    public String identity() {
        return this.identity;
    }

    public ImageRegistryCredential withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public String identityUrl() {
        return this.identityUrl;
    }

    public ImageRegistryCredential withIdentityUrl(String identityUrl) {
        this.identityUrl = identityUrl;
        return this;
    }

    public void validate() {
        if (this.server() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property server in model ImageRegistryCredential"));
        }
        if (this.username() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property username in model ImageRegistryCredential"));
        }
    }
}

