/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.resourcemanager.containerinstance.ContainerInstanceManager;
import com.azure.resourcemanager.containerinstance.fluent.ContainerGroupsClient;
import com.azure.resourcemanager.containerinstance.fluent.ContainerInstanceManagementClient;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerGroupInner;
import com.azure.resourcemanager.containerinstance.fluent.models.LogsInner;
import com.azure.resourcemanager.containerinstance.implementation.ContainerGroupImpl;
import com.azure.resourcemanager.containerinstance.models.CachedImages;
import com.azure.resourcemanager.containerinstance.models.Capabilities;
import com.azure.resourcemanager.containerinstance.models.ContainerGroup;
import com.azure.resourcemanager.containerinstance.models.ContainerGroups;
import com.azure.resourcemanager.containerinstance.models.Operation;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import reactor.core.publisher.Mono;

public class ContainerGroupsImpl
extends TopLevelModifiableResourcesImpl<ContainerGroup, ContainerGroupImpl, ContainerGroupInner, ContainerGroupsClient, ContainerInstanceManager>
implements ContainerGroups {
    public ContainerGroupsImpl(ContainerInstanceManager manager) {
        super((InnerSupportsListing)((ContainerInstanceManagementClient)manager.serviceClient()).getContainerGroups(), (Manager)manager);
    }

    protected ContainerGroupImpl wrapModel(String name) {
        return new ContainerGroupImpl(name, new ContainerGroupInner(), (ContainerInstanceManager)this.manager());
    }

    protected ContainerGroupImpl wrapModel(ContainerGroupInner inner) {
        if (inner == null) {
            return null;
        }
        return new ContainerGroupImpl(inner.name(), inner, (ContainerInstanceManager)this.manager());
    }

    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().deleteAsync(resourceGroupName, name).then();
    }

    public ContainerGroup.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public String getLogContent(String resourceGroupName, String containerGroupName, String containerName) {
        LogsInner logsInner = ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainers().listLogs(resourceGroupName, containerGroupName, containerName);
        return logsInner != null ? logsInner.content() : null;
    }

    @Override
    public String getLogContent(String resourceGroupName, String containerGroupName, String containerName, int tailLineCount) {
        LogsInner logsInner = (LogsInner)((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainers().listLogsWithResponse(resourceGroupName, containerGroupName, containerName, tailLineCount, Context.NONE).getValue();
        return logsInner != null ? logsInner.content() : null;
    }

    @Override
    public Mono<String> getLogContentAsync(String resourceGroupName, String containerGroupName, String containerName) {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainers().listLogsAsync(resourceGroupName, containerGroupName, containerName).map(LogsInner::content);
    }

    @Override
    public Mono<String> getLogContentAsync(String resourceGroupName, String containerGroupName, String containerName, int tailLineCount) {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainers().listLogsAsync(resourceGroupName, containerGroupName, containerName, tailLineCount).map(LogsInner::content);
    }

    @Override
    public PagedIterable<Operation> listOperations() {
        return new PagedIterable(this.listOperationsAsync());
    }

    @Override
    public PagedFlux<Operation> listOperationsAsync() {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getOperations().listAsync();
    }

    @Override
    public PagedIterable<CachedImages> listCachedImages(String location) {
        return new PagedIterable(this.listCachedImagesAsync(location));
    }

    @Override
    public PagedFlux<CachedImages> listCachedImagesAsync(String location) {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getLocations().listCachedImagesAsync(location);
    }

    @Override
    public PagedIterable<Capabilities> listCapabilities(String location) {
        return new PagedIterable(this.listCapabilitiesAsync(location));
    }

    @Override
    public PagedFlux<Capabilities> listCapabilitiesAsync(String location) {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getLocations().listCapabilitiesAsync(location);
    }

    @Override
    public void start(String resourceGroupName, String containerGroupName) {
        ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().start(resourceGroupName, containerGroupName);
    }

    @Override
    public Mono<Void> startAsync(String resourceGroupName, String containerGroupName) {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().startAsync(resourceGroupName, containerGroupName);
    }

    public PagedFlux<ContainerGroup> listAsync() {
        return this.wrapPageAsync(((ContainerGroupsClient)this.inner()).listAsync());
    }

    public PagedFlux<ContainerGroup> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((ContainerGroupsClient)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    public final PagedIterable<ContainerGroup> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedIterable<ContainerGroup> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }
}

