/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computerecommender.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computerecommender.models.ResourceSize;
import java.io.IOException;
import java.util.List;

public final class SpotPlacementScoresInput
implements JsonSerializable<SpotPlacementScoresInput> {
    private List<String> desiredLocations;
    private List<ResourceSize> desiredSizes;
    private Integer desiredCount;
    private Boolean availabilityZones;

    public List<String> desiredLocations() {
        return this.desiredLocations;
    }

    public SpotPlacementScoresInput withDesiredLocations(List<String> desiredLocations) {
        this.desiredLocations = desiredLocations;
        return this;
    }

    public List<ResourceSize> desiredSizes() {
        return this.desiredSizes;
    }

    public SpotPlacementScoresInput withDesiredSizes(List<ResourceSize> desiredSizes) {
        this.desiredSizes = desiredSizes;
        return this;
    }

    public Integer desiredCount() {
        return this.desiredCount;
    }

    public SpotPlacementScoresInput withDesiredCount(Integer desiredCount) {
        this.desiredCount = desiredCount;
        return this;
    }

    public Boolean availabilityZones() {
        return this.availabilityZones;
    }

    public SpotPlacementScoresInput withAvailabilityZones(Boolean availabilityZones) {
        this.availabilityZones = availabilityZones;
        return this;
    }

    public void validate() {
        if (this.desiredSizes() != null) {
            this.desiredSizes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("desiredLocations", this.desiredLocations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("desiredSizes", this.desiredSizes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("desiredCount", (Number)this.desiredCount);
        jsonWriter.writeBooleanField("availabilityZones", this.availabilityZones);
        return jsonWriter.writeEndObject();
    }

    public static SpotPlacementScoresInput fromJson(JsonReader jsonReader) throws IOException {
        return (SpotPlacementScoresInput)jsonReader.readObject(reader -> {
            SpotPlacementScoresInput deserializedSpotPlacementScoresInput = new SpotPlacementScoresInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("desiredLocations".equals(fieldName)) {
                    List desiredLocations;
                    deserializedSpotPlacementScoresInput.desiredLocations = desiredLocations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("desiredSizes".equals(fieldName)) {
                    List desiredSizes;
                    deserializedSpotPlacementScoresInput.desiredSizes = desiredSizes = reader.readArray(reader1 -> ResourceSize.fromJson(reader1));
                    continue;
                }
                if ("desiredCount".equals(fieldName)) {
                    deserializedSpotPlacementScoresInput.desiredCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("availabilityZones".equals(fieldName)) {
                    deserializedSpotPlacementScoresInput.availabilityZones = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSpotPlacementScoresInput;
        });
    }
}

