/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computerecommender.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.computerecommender.ComputeRecommenderManager;
import com.azure.resourcemanager.computerecommender.fluent.SpotPlacementScoresClient;
import com.azure.resourcemanager.computerecommender.fluent.models.ComputeDiagnosticBaseInner;
import com.azure.resourcemanager.computerecommender.fluent.models.SpotPlacementScoresResponseInner;
import com.azure.resourcemanager.computerecommender.implementation.ComputeDiagnosticBaseImpl;
import com.azure.resourcemanager.computerecommender.implementation.SpotPlacementScoresResponseImpl;
import com.azure.resourcemanager.computerecommender.models.ComputeDiagnosticBase;
import com.azure.resourcemanager.computerecommender.models.SpotPlacementScores;
import com.azure.resourcemanager.computerecommender.models.SpotPlacementScoresInput;
import com.azure.resourcemanager.computerecommender.models.SpotPlacementScoresResponse;

public final class SpotPlacementScoresImpl
implements SpotPlacementScores {
    private static final ClientLogger LOGGER = new ClientLogger(SpotPlacementScoresImpl.class);
    private final SpotPlacementScoresClient innerClient;
    private final ComputeRecommenderManager serviceManager;

    public SpotPlacementScoresImpl(SpotPlacementScoresClient innerClient, ComputeRecommenderManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ComputeDiagnosticBase> getWithResponse(String location, Context context) {
        Response<ComputeDiagnosticBaseInner> inner = this.serviceClient().getWithResponse(location, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ComputeDiagnosticBaseImpl((ComputeDiagnosticBaseInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ComputeDiagnosticBase get(String location) {
        ComputeDiagnosticBaseInner inner = this.serviceClient().get(location);
        if (inner != null) {
            return new ComputeDiagnosticBaseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<SpotPlacementScoresResponse> postWithResponse(String location, SpotPlacementScoresInput spotPlacementScoresInput, Context context) {
        Response<SpotPlacementScoresResponseInner> inner = this.serviceClient().postWithResponse(location, spotPlacementScoresInput, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SpotPlacementScoresResponseImpl((SpotPlacementScoresResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SpotPlacementScoresResponse post(String location, SpotPlacementScoresInput spotPlacementScoresInput) {
        SpotPlacementScoresResponseInner inner = this.serviceClient().post(location, spotPlacementScoresInput);
        if (inner != null) {
            return new SpotPlacementScoresResponseImpl(inner, this.manager());
        }
        return null;
    }

    private SpotPlacementScoresClient serviceClient() {
        return this.innerClient;
    }

    private ComputeRecommenderManager manager() {
        return this.serviceManager;
    }
}

