/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computerecommender.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computerecommender.models.PlacementScore;
import com.azure.resourcemanager.computerecommender.models.ResourceSize;
import java.io.IOException;
import java.util.List;

public final class SpotPlacementScoresResponseInner
implements JsonSerializable<SpotPlacementScoresResponseInner> {
    private List<String> desiredLocations;
    private List<ResourceSize> desiredSizes;
    private Integer desiredCount;
    private Boolean availabilityZones;
    private List<PlacementScore> placementScores;

    private SpotPlacementScoresResponseInner() {
    }

    public List<String> desiredLocations() {
        return this.desiredLocations;
    }

    public List<ResourceSize> desiredSizes() {
        return this.desiredSizes;
    }

    public Integer desiredCount() {
        return this.desiredCount;
    }

    public Boolean availabilityZones() {
        return this.availabilityZones;
    }

    public List<PlacementScore> placementScores() {
        return this.placementScores;
    }

    public void validate() {
        if (this.desiredSizes() != null) {
            this.desiredSizes().forEach(e -> e.validate());
        }
        if (this.placementScores() != null) {
            this.placementScores().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("desiredLocations", this.desiredLocations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("desiredSizes", this.desiredSizes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("desiredCount", (Number)this.desiredCount);
        jsonWriter.writeBooleanField("availabilityZones", this.availabilityZones);
        jsonWriter.writeArrayField("placementScores", this.placementScores, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SpotPlacementScoresResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return (SpotPlacementScoresResponseInner)jsonReader.readObject(reader -> {
            SpotPlacementScoresResponseInner deserializedSpotPlacementScoresResponseInner = new SpotPlacementScoresResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("desiredLocations".equals(fieldName)) {
                    List desiredLocations;
                    deserializedSpotPlacementScoresResponseInner.desiredLocations = desiredLocations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("desiredSizes".equals(fieldName)) {
                    List desiredSizes;
                    deserializedSpotPlacementScoresResponseInner.desiredSizes = desiredSizes = reader.readArray(reader1 -> ResourceSize.fromJson(reader1));
                    continue;
                }
                if ("desiredCount".equals(fieldName)) {
                    deserializedSpotPlacementScoresResponseInner.desiredCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("availabilityZones".equals(fieldName)) {
                    deserializedSpotPlacementScoresResponseInner.availabilityZones = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("placementScores".equals(fieldName)) {
                    List placementScores;
                    deserializedSpotPlacementScoresResponseInner.placementScores = placementScores = reader.readArray(reader1 -> PlacementScore.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSpotPlacementScoresResponseInner;
        });
    }
}

