/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computelimit.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computelimit.models.LimitName;
import com.azure.resourcemanager.computelimit.models.ResourceProvisioningState;
import java.io.IOException;

public final class SharedLimitProperties
implements JsonSerializable<SharedLimitProperties> {
    private LimitName resourceName;
    private Integer limit;
    private String unit;
    private ResourceProvisioningState provisioningState;

    public LimitName resourceName() {
        return this.resourceName;
    }

    public Integer limit() {
        return this.limit;
    }

    public String unit() {
        return this.unit;
    }

    public ResourceProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SharedLimitProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SharedLimitProperties)jsonReader.readObject(reader -> {
            SharedLimitProperties deserializedSharedLimitProperties = new SharedLimitProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceName".equals(fieldName)) {
                    deserializedSharedLimitProperties.resourceName = LimitName.fromJson(reader);
                    continue;
                }
                if ("limit".equals(fieldName)) {
                    deserializedSharedLimitProperties.limit = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedSharedLimitProperties.unit = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSharedLimitProperties.provisioningState = ResourceProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSharedLimitProperties;
        });
    }
}

