/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computelimit.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.computelimit.ComputeLimitManager;
import com.azure.resourcemanager.computelimit.fluent.SharedLimitsClient;
import com.azure.resourcemanager.computelimit.fluent.models.SharedLimitInner;
import com.azure.resourcemanager.computelimit.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.computelimit.implementation.SharedLimitImpl;
import com.azure.resourcemanager.computelimit.models.SharedLimit;
import com.azure.resourcemanager.computelimit.models.SharedLimits;

public final class SharedLimitsImpl
implements SharedLimits {
    private static final ClientLogger LOGGER = new ClientLogger(SharedLimitsImpl.class);
    private final SharedLimitsClient innerClient;
    private final ComputeLimitManager serviceManager;

    public SharedLimitsImpl(SharedLimitsClient innerClient, ComputeLimitManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SharedLimit> getWithResponse(String location, String name, Context context) {
        Response<SharedLimitInner> inner = this.serviceClient().getWithResponse(location, name, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SharedLimitImpl((SharedLimitInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SharedLimit get(String location, String name) {
        SharedLimitInner inner = this.serviceClient().get(location, name);
        if (inner != null) {
            return new SharedLimitImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String location, String name, Context context) {
        return this.serviceClient().deleteWithResponse(location, name, context);
    }

    @Override
    public void deleteByResourceGroup(String location, String name) {
        this.serviceClient().delete(location, name);
    }

    @Override
    public PagedIterable<SharedLimit> listBySubscriptionLocationResource(String location) {
        PagedIterable<SharedLimitInner> inner = this.serviceClient().listBySubscriptionLocationResource(location);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SharedLimitImpl((SharedLimitInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SharedLimit> listBySubscriptionLocationResource(String location, Context context) {
        PagedIterable<SharedLimitInner> inner = this.serviceClient().listBySubscriptionLocationResource(location, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SharedLimitImpl((SharedLimitInner)((Object)inner1), this.manager()));
    }

    @Override
    public SharedLimit getById(String id) {
        String location = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (location == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "sharedLimits");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sharedLimits'.", id)));
        }
        return (SharedLimit)this.getWithResponse(location, name, Context.NONE).getValue();
    }

    @Override
    public Response<SharedLimit> getByIdWithResponse(String id, Context context) {
        String location = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (location == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "sharedLimits");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sharedLimits'.", id)));
        }
        return this.getWithResponse(location, name, context);
    }

    @Override
    public void deleteById(String id) {
        String location = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (location == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "sharedLimits");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sharedLimits'.", id)));
        }
        this.deleteByResourceGroupWithResponse(location, name, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String location = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (location == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String name = ResourceManagerUtils.getValueFromIdByName(id, "sharedLimits");
        if (name == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sharedLimits'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(location, name, context);
    }

    private SharedLimitsClient serviceClient() {
        return this.innerClient;
    }

    private ComputeLimitManager manager() {
        return this.serviceManager;
    }

    @Override
    public SharedLimitImpl define(String name) {
        return new SharedLimitImpl(name, this.manager());
    }
}

