/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computelimit.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.computelimit.ComputeLimitManager;
import com.azure.resourcemanager.computelimit.fluent.GuestSubscriptionsClient;
import com.azure.resourcemanager.computelimit.fluent.models.GuestSubscriptionInner;
import com.azure.resourcemanager.computelimit.implementation.GuestSubscriptionImpl;
import com.azure.resourcemanager.computelimit.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.computelimit.models.GuestSubscription;
import com.azure.resourcemanager.computelimit.models.GuestSubscriptions;

public final class GuestSubscriptionsImpl
implements GuestSubscriptions {
    private static final ClientLogger LOGGER = new ClientLogger(GuestSubscriptionsImpl.class);
    private final GuestSubscriptionsClient innerClient;
    private final ComputeLimitManager serviceManager;

    public GuestSubscriptionsImpl(GuestSubscriptionsClient innerClient, ComputeLimitManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<GuestSubscription> getWithResponse(String location, String guestSubscriptionId, Context context) {
        Response<GuestSubscriptionInner> inner = this.serviceClient().getWithResponse(location, guestSubscriptionId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new GuestSubscriptionImpl((GuestSubscriptionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public GuestSubscription get(String location, String guestSubscriptionId) {
        GuestSubscriptionInner inner = this.serviceClient().get(location, guestSubscriptionId);
        if (inner != null) {
            return new GuestSubscriptionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String location, String guestSubscriptionId, Context context) {
        return this.serviceClient().deleteWithResponse(location, guestSubscriptionId, context);
    }

    @Override
    public void deleteByResourceGroup(String location, String guestSubscriptionId) {
        this.serviceClient().delete(location, guestSubscriptionId);
    }

    @Override
    public PagedIterable<GuestSubscription> listBySubscriptionLocationResource(String location) {
        PagedIterable<GuestSubscriptionInner> inner = this.serviceClient().listBySubscriptionLocationResource(location);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GuestSubscriptionImpl((GuestSubscriptionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<GuestSubscription> listBySubscriptionLocationResource(String location, Context context) {
        PagedIterable<GuestSubscriptionInner> inner = this.serviceClient().listBySubscriptionLocationResource(location, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GuestSubscriptionImpl((GuestSubscriptionInner)((Object)inner1), this.manager()));
    }

    @Override
    public GuestSubscription getById(String id) {
        String location = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (location == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String guestSubscriptionId = ResourceManagerUtils.getValueFromIdByName(id, "guestSubscriptions");
        if (guestSubscriptionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'guestSubscriptions'.", id)));
        }
        return (GuestSubscription)this.getWithResponse(location, guestSubscriptionId, Context.NONE).getValue();
    }

    @Override
    public Response<GuestSubscription> getByIdWithResponse(String id, Context context) {
        String location = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (location == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String guestSubscriptionId = ResourceManagerUtils.getValueFromIdByName(id, "guestSubscriptions");
        if (guestSubscriptionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'guestSubscriptions'.", id)));
        }
        return this.getWithResponse(location, guestSubscriptionId, context);
    }

    @Override
    public void deleteById(String id) {
        String location = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (location == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String guestSubscriptionId = ResourceManagerUtils.getValueFromIdByName(id, "guestSubscriptions");
        if (guestSubscriptionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'guestSubscriptions'.", id)));
        }
        this.deleteByResourceGroupWithResponse(location, guestSubscriptionId, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String location = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (location == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String guestSubscriptionId = ResourceManagerUtils.getValueFromIdByName(id, "guestSubscriptions");
        if (guestSubscriptionId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'guestSubscriptions'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(location, guestSubscriptionId, context);
    }

    private GuestSubscriptionsClient serviceClient() {
        return this.innerClient;
    }

    private ComputeLimitManager manager() {
        return this.serviceManager;
    }

    @Override
    public GuestSubscriptionImpl define(String name) {
        return new GuestSubscriptionImpl(name, this.manager());
    }
}

