/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.ProtocolTypes;
import java.io.IOException;

public final class WinRMListener
implements JsonSerializable<WinRMListener> {
    private ProtocolTypes protocol;
    private String certificateUrl;

    public ProtocolTypes protocol() {
        return this.protocol;
    }

    public WinRMListener withProtocol(ProtocolTypes protocol) {
        this.protocol = protocol;
        return this;
    }

    public String certificateUrl() {
        return this.certificateUrl;
    }

    public WinRMListener withCertificateUrl(String certificateUrl) {
        this.certificateUrl = certificateUrl;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeStringField("certificateUrl", this.certificateUrl);
        return jsonWriter.writeEndObject();
    }

    public static WinRMListener fromJson(JsonReader jsonReader) throws IOException {
        return (WinRMListener)jsonReader.readObject(reader -> {
            WinRMListener deserializedWinRMListener = new WinRMListener();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("protocol".equals(fieldName)) {
                    deserializedWinRMListener.protocol = ProtocolTypes.fromString(reader.getString());
                    continue;
                }
                if ("certificateUrl".equals(fieldName)) {
                    deserializedWinRMListener.certificateUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWinRMListener;
        });
    }
}

