/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.LinuxConfiguration;
import com.azure.resourcemanager.computefleet.models.VaultSecretGroup;
import com.azure.resourcemanager.computefleet.models.WindowsConfiguration;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetOSProfile
implements JsonSerializable<VirtualMachineScaleSetOSProfile> {
    private String computerNamePrefix;
    private String adminUsername;
    private String adminPassword;
    private String customData;
    private WindowsConfiguration windowsConfiguration;
    private LinuxConfiguration linuxConfiguration;
    private List<VaultSecretGroup> secrets;
    private Boolean allowExtensionOperations;
    private Boolean requireGuestProvisionSignal;

    public String computerNamePrefix() {
        return this.computerNamePrefix;
    }

    public VirtualMachineScaleSetOSProfile withComputerNamePrefix(String computerNamePrefix) {
        this.computerNamePrefix = computerNamePrefix;
        return this;
    }

    public String adminUsername() {
        return this.adminUsername;
    }

    public VirtualMachineScaleSetOSProfile withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return this;
    }

    public String adminPassword() {
        return this.adminPassword;
    }

    public VirtualMachineScaleSetOSProfile withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return this;
    }

    public String customData() {
        return this.customData;
    }

    public VirtualMachineScaleSetOSProfile withCustomData(String customData) {
        this.customData = customData;
        return this;
    }

    public WindowsConfiguration windowsConfiguration() {
        return this.windowsConfiguration;
    }

    public VirtualMachineScaleSetOSProfile withWindowsConfiguration(WindowsConfiguration windowsConfiguration) {
        this.windowsConfiguration = windowsConfiguration;
        return this;
    }

    public LinuxConfiguration linuxConfiguration() {
        return this.linuxConfiguration;
    }

    public VirtualMachineScaleSetOSProfile withLinuxConfiguration(LinuxConfiguration linuxConfiguration) {
        this.linuxConfiguration = linuxConfiguration;
        return this;
    }

    public List<VaultSecretGroup> secrets() {
        return this.secrets;
    }

    public VirtualMachineScaleSetOSProfile withSecrets(List<VaultSecretGroup> secrets) {
        this.secrets = secrets;
        return this;
    }

    public Boolean allowExtensionOperations() {
        return this.allowExtensionOperations;
    }

    public VirtualMachineScaleSetOSProfile withAllowExtensionOperations(Boolean allowExtensionOperations) {
        this.allowExtensionOperations = allowExtensionOperations;
        return this;
    }

    public Boolean requireGuestProvisionSignal() {
        return this.requireGuestProvisionSignal;
    }

    public VirtualMachineScaleSetOSProfile withRequireGuestProvisionSignal(Boolean requireGuestProvisionSignal) {
        this.requireGuestProvisionSignal = requireGuestProvisionSignal;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("computerNamePrefix", this.computerNamePrefix);
        jsonWriter.writeStringField("adminUsername", this.adminUsername);
        jsonWriter.writeStringField("adminPassword", this.adminPassword);
        jsonWriter.writeStringField("customData", this.customData);
        jsonWriter.writeJsonField("windowsConfiguration", (JsonSerializable)this.windowsConfiguration);
        jsonWriter.writeJsonField("linuxConfiguration", (JsonSerializable)this.linuxConfiguration);
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("allowExtensionOperations", this.allowExtensionOperations);
        jsonWriter.writeBooleanField("requireGuestProvisionSignal", this.requireGuestProvisionSignal);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetOSProfile fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetOSProfile)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetOSProfile deserializedVirtualMachineScaleSetOSProfile = new VirtualMachineScaleSetOSProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("computerNamePrefix".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSProfile.computerNamePrefix = reader.getString();
                    continue;
                }
                if ("adminUsername".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSProfile.adminUsername = reader.getString();
                    continue;
                }
                if ("adminPassword".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSProfile.adminPassword = reader.getString();
                    continue;
                }
                if ("customData".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSProfile.customData = reader.getString();
                    continue;
                }
                if ("windowsConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSProfile.windowsConfiguration = WindowsConfiguration.fromJson(reader);
                    continue;
                }
                if ("linuxConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSProfile.linuxConfiguration = LinuxConfiguration.fromJson(reader);
                    continue;
                }
                if ("secrets".equals(fieldName)) {
                    List secrets;
                    deserializedVirtualMachineScaleSetOSProfile.secrets = secrets = reader.readArray(reader1 -> VaultSecretGroup.fromJson(reader1));
                    continue;
                }
                if ("allowExtensionOperations".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSProfile.allowExtensionOperations = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("requireGuestProvisionSignal".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSProfile.requireGuestProvisionSignal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetOSProfile;
        });
    }
}

