/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.ApiEntityReference;
import com.azure.resourcemanager.computefleet.models.NetworkApiVersion;
import com.azure.resourcemanager.computefleet.models.VirtualMachineScaleSetNetworkConfiguration;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetNetworkProfile
implements JsonSerializable<VirtualMachineScaleSetNetworkProfile> {
    private ApiEntityReference healthProbe;
    private List<VirtualMachineScaleSetNetworkConfiguration> networkInterfaceConfigurations;
    private NetworkApiVersion networkApiVersion;

    public ApiEntityReference healthProbe() {
        return this.healthProbe;
    }

    public VirtualMachineScaleSetNetworkProfile withHealthProbe(ApiEntityReference healthProbe) {
        this.healthProbe = healthProbe;
        return this;
    }

    public List<VirtualMachineScaleSetNetworkConfiguration> networkInterfaceConfigurations() {
        return this.networkInterfaceConfigurations;
    }

    public VirtualMachineScaleSetNetworkProfile withNetworkInterfaceConfigurations(List<VirtualMachineScaleSetNetworkConfiguration> networkInterfaceConfigurations) {
        this.networkInterfaceConfigurations = networkInterfaceConfigurations;
        return this;
    }

    public NetworkApiVersion networkApiVersion() {
        return this.networkApiVersion;
    }

    public VirtualMachineScaleSetNetworkProfile withNetworkApiVersion(NetworkApiVersion networkApiVersion) {
        this.networkApiVersion = networkApiVersion;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("healthProbe", (JsonSerializable)this.healthProbe);
        jsonWriter.writeArrayField("networkInterfaceConfigurations", this.networkInterfaceConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("networkApiVersion", this.networkApiVersion == null ? null : this.networkApiVersion.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetNetworkProfile fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetNetworkProfile)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetNetworkProfile deserializedVirtualMachineScaleSetNetworkProfile = new VirtualMachineScaleSetNetworkProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("healthProbe".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetNetworkProfile.healthProbe = ApiEntityReference.fromJson(reader);
                    continue;
                }
                if ("networkInterfaceConfigurations".equals(fieldName)) {
                    List networkInterfaceConfigurations;
                    deserializedVirtualMachineScaleSetNetworkProfile.networkInterfaceConfigurations = networkInterfaceConfigurations = reader.readArray(reader1 -> VirtualMachineScaleSetNetworkConfiguration.fromJson(reader1));
                    continue;
                }
                if ("networkApiVersion".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetNetworkProfile.networkApiVersion = NetworkApiVersion.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetNetworkProfile;
        });
    }
}

