/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.EvictionPolicy;
import com.azure.resourcemanager.computefleet.models.SpotAllocationStrategy;
import java.io.IOException;

public final class SpotPriorityProfile
implements JsonSerializable<SpotPriorityProfile> {
    private Integer capacity;
    private Integer minCapacity;
    private Double maxPricePerVM;
    private EvictionPolicy evictionPolicy;
    private SpotAllocationStrategy allocationStrategy;
    private Boolean maintain;

    public Integer capacity() {
        return this.capacity;
    }

    public SpotPriorityProfile withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public Integer minCapacity() {
        return this.minCapacity;
    }

    public SpotPriorityProfile withMinCapacity(Integer minCapacity) {
        this.minCapacity = minCapacity;
        return this;
    }

    public Double maxPricePerVM() {
        return this.maxPricePerVM;
    }

    public SpotPriorityProfile withMaxPricePerVM(Double maxPricePerVM) {
        this.maxPricePerVM = maxPricePerVM;
        return this;
    }

    public EvictionPolicy evictionPolicy() {
        return this.evictionPolicy;
    }

    public SpotPriorityProfile withEvictionPolicy(EvictionPolicy evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public SpotAllocationStrategy allocationStrategy() {
        return this.allocationStrategy;
    }

    public SpotPriorityProfile withAllocationStrategy(SpotAllocationStrategy allocationStrategy) {
        this.allocationStrategy = allocationStrategy;
        return this;
    }

    public Boolean maintain() {
        return this.maintain;
    }

    public SpotPriorityProfile withMaintain(Boolean maintain) {
        this.maintain = maintain;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("capacity", (Number)this.capacity);
        jsonWriter.writeNumberField("minCapacity", (Number)this.minCapacity);
        jsonWriter.writeNumberField("maxPricePerVM", (Number)this.maxPricePerVM);
        jsonWriter.writeStringField("evictionPolicy", this.evictionPolicy == null ? null : this.evictionPolicy.toString());
        jsonWriter.writeStringField("allocationStrategy", this.allocationStrategy == null ? null : this.allocationStrategy.toString());
        jsonWriter.writeBooleanField("maintain", this.maintain);
        return jsonWriter.writeEndObject();
    }

    public static SpotPriorityProfile fromJson(JsonReader jsonReader) throws IOException {
        return (SpotPriorityProfile)jsonReader.readObject(reader -> {
            SpotPriorityProfile deserializedSpotPriorityProfile = new SpotPriorityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("capacity".equals(fieldName)) {
                    deserializedSpotPriorityProfile.capacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("minCapacity".equals(fieldName)) {
                    deserializedSpotPriorityProfile.minCapacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxPricePerVM".equals(fieldName)) {
                    deserializedSpotPriorityProfile.maxPricePerVM = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("evictionPolicy".equals(fieldName)) {
                    deserializedSpotPriorityProfile.evictionPolicy = EvictionPolicy.fromString(reader.getString());
                    continue;
                }
                if ("allocationStrategy".equals(fieldName)) {
                    deserializedSpotPriorityProfile.allocationStrategy = SpotAllocationStrategy.fromString(reader.getString());
                    continue;
                }
                if ("maintain".equals(fieldName)) {
                    deserializedSpotPriorityProfile.maintain = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSpotPriorityProfile;
        });
    }
}

