/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.RegularPriorityAllocationStrategy;
import java.io.IOException;

public final class RegularPriorityProfile
implements JsonSerializable<RegularPriorityProfile> {
    private Integer capacity;
    private Integer minCapacity;
    private RegularPriorityAllocationStrategy allocationStrategy;

    public Integer capacity() {
        return this.capacity;
    }

    public RegularPriorityProfile withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public Integer minCapacity() {
        return this.minCapacity;
    }

    public RegularPriorityProfile withMinCapacity(Integer minCapacity) {
        this.minCapacity = minCapacity;
        return this;
    }

    public RegularPriorityAllocationStrategy allocationStrategy() {
        return this.allocationStrategy;
    }

    public RegularPriorityProfile withAllocationStrategy(RegularPriorityAllocationStrategy allocationStrategy) {
        this.allocationStrategy = allocationStrategy;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("capacity", (Number)this.capacity);
        jsonWriter.writeNumberField("minCapacity", (Number)this.minCapacity);
        jsonWriter.writeStringField("allocationStrategy", this.allocationStrategy == null ? null : this.allocationStrategy.toString());
        return jsonWriter.writeEndObject();
    }

    public static RegularPriorityProfile fromJson(JsonReader jsonReader) throws IOException {
        return (RegularPriorityProfile)jsonReader.readObject(reader -> {
            RegularPriorityProfile deserializedRegularPriorityProfile = new RegularPriorityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("capacity".equals(fieldName)) {
                    deserializedRegularPriorityProfile.capacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("minCapacity".equals(fieldName)) {
                    deserializedRegularPriorityProfile.minCapacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allocationStrategy".equals(fieldName)) {
                    deserializedRegularPriorityProfile.allocationStrategy = RegularPriorityAllocationStrategy.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRegularPriorityProfile;
        });
    }
}

