/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.AdditionalLocationsProfile;
import com.azure.resourcemanager.computefleet.models.CapacityType;
import com.azure.resourcemanager.computefleet.models.ComputeProfile;
import com.azure.resourcemanager.computefleet.models.FleetMode;
import com.azure.resourcemanager.computefleet.models.ProvisioningState;
import com.azure.resourcemanager.computefleet.models.RegularPriorityProfile;
import com.azure.resourcemanager.computefleet.models.SpotPriorityProfile;
import com.azure.resourcemanager.computefleet.models.VMAttributes;
import com.azure.resourcemanager.computefleet.models.VmSizeProfile;
import com.azure.resourcemanager.computefleet.models.ZoneAllocationPolicy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class FleetProperties
implements JsonSerializable<FleetProperties> {
    private ProvisioningState provisioningState;
    private SpotPriorityProfile spotPriorityProfile;
    private RegularPriorityProfile regularPriorityProfile;
    private List<VmSizeProfile> vmSizesProfile;
    private VMAttributes vmAttributes;
    private AdditionalLocationsProfile additionalLocationsProfile;
    private ComputeProfile computeProfile;
    private OffsetDateTime timeCreated;
    private String uniqueId;
    private FleetMode mode;
    private CapacityType capacityType;
    private ZoneAllocationPolicy zoneAllocationPolicy;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public SpotPriorityProfile spotPriorityProfile() {
        return this.spotPriorityProfile;
    }

    public FleetProperties withSpotPriorityProfile(SpotPriorityProfile spotPriorityProfile) {
        this.spotPriorityProfile = spotPriorityProfile;
        return this;
    }

    public RegularPriorityProfile regularPriorityProfile() {
        return this.regularPriorityProfile;
    }

    public FleetProperties withRegularPriorityProfile(RegularPriorityProfile regularPriorityProfile) {
        this.regularPriorityProfile = regularPriorityProfile;
        return this;
    }

    public List<VmSizeProfile> vmSizesProfile() {
        return this.vmSizesProfile;
    }

    public FleetProperties withVmSizesProfile(List<VmSizeProfile> vmSizesProfile) {
        this.vmSizesProfile = vmSizesProfile;
        return this;
    }

    public VMAttributes vmAttributes() {
        return this.vmAttributes;
    }

    public FleetProperties withVmAttributes(VMAttributes vmAttributes) {
        this.vmAttributes = vmAttributes;
        return this;
    }

    public AdditionalLocationsProfile additionalLocationsProfile() {
        return this.additionalLocationsProfile;
    }

    public FleetProperties withAdditionalLocationsProfile(AdditionalLocationsProfile additionalLocationsProfile) {
        this.additionalLocationsProfile = additionalLocationsProfile;
        return this;
    }

    public ComputeProfile computeProfile() {
        return this.computeProfile;
    }

    public FleetProperties withComputeProfile(ComputeProfile computeProfile) {
        this.computeProfile = computeProfile;
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public FleetMode mode() {
        return this.mode;
    }

    public FleetProperties withMode(FleetMode mode) {
        this.mode = mode;
        return this;
    }

    public CapacityType capacityType() {
        return this.capacityType;
    }

    public FleetProperties withCapacityType(CapacityType capacityType) {
        this.capacityType = capacityType;
        return this;
    }

    public ZoneAllocationPolicy zoneAllocationPolicy() {
        return this.zoneAllocationPolicy;
    }

    public FleetProperties withZoneAllocationPolicy(ZoneAllocationPolicy zoneAllocationPolicy) {
        this.zoneAllocationPolicy = zoneAllocationPolicy;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("vmSizesProfile", this.vmSizesProfile, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("computeProfile", (JsonSerializable)this.computeProfile);
        jsonWriter.writeJsonField("spotPriorityProfile", (JsonSerializable)this.spotPriorityProfile);
        jsonWriter.writeJsonField("regularPriorityProfile", (JsonSerializable)this.regularPriorityProfile);
        jsonWriter.writeJsonField("vmAttributes", (JsonSerializable)this.vmAttributes);
        jsonWriter.writeJsonField("additionalLocationsProfile", (JsonSerializable)this.additionalLocationsProfile);
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeStringField("capacityType", this.capacityType == null ? null : this.capacityType.toString());
        jsonWriter.writeJsonField("zoneAllocationPolicy", (JsonSerializable)this.zoneAllocationPolicy);
        return jsonWriter.writeEndObject();
    }

    public static FleetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FleetProperties)jsonReader.readObject(reader -> {
            FleetProperties deserializedFleetProperties = new FleetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vmSizesProfile".equals(fieldName)) {
                    List vmSizesProfile;
                    deserializedFleetProperties.vmSizesProfile = vmSizesProfile = reader.readArray(reader1 -> VmSizeProfile.fromJson(reader1));
                    continue;
                }
                if ("computeProfile".equals(fieldName)) {
                    deserializedFleetProperties.computeProfile = ComputeProfile.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedFleetProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("spotPriorityProfile".equals(fieldName)) {
                    deserializedFleetProperties.spotPriorityProfile = SpotPriorityProfile.fromJson(reader);
                    continue;
                }
                if ("regularPriorityProfile".equals(fieldName)) {
                    deserializedFleetProperties.regularPriorityProfile = RegularPriorityProfile.fromJson(reader);
                    continue;
                }
                if ("vmAttributes".equals(fieldName)) {
                    deserializedFleetProperties.vmAttributes = VMAttributes.fromJson(reader);
                    continue;
                }
                if ("additionalLocationsProfile".equals(fieldName)) {
                    deserializedFleetProperties.additionalLocationsProfile = AdditionalLocationsProfile.fromJson(reader);
                    continue;
                }
                if ("timeCreated".equals(fieldName)) {
                    deserializedFleetProperties.timeCreated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("uniqueId".equals(fieldName)) {
                    deserializedFleetProperties.uniqueId = reader.getString();
                    continue;
                }
                if ("mode".equals(fieldName)) {
                    deserializedFleetProperties.mode = FleetMode.fromString(reader.getString());
                    continue;
                }
                if ("capacityType".equals(fieldName)) {
                    deserializedFleetProperties.capacityType = CapacityType.fromString(reader.getString());
                    continue;
                }
                if ("zoneAllocationPolicy".equals(fieldName)) {
                    deserializedFleetProperties.zoneAllocationPolicy = ZoneAllocationPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFleetProperties;
        });
    }
}

