/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.AdditionalCapabilities;
import com.azure.resourcemanager.computefleet.models.BaseVirtualMachineProfile;
import java.io.IOException;

public final class ComputeProfile
implements JsonSerializable<ComputeProfile> {
    private BaseVirtualMachineProfile baseVirtualMachineProfile;
    private String computeApiVersion;
    private Integer platformFaultDomainCount;
    private AdditionalCapabilities additionalVirtualMachineCapabilities;

    public BaseVirtualMachineProfile baseVirtualMachineProfile() {
        return this.baseVirtualMachineProfile;
    }

    public ComputeProfile withBaseVirtualMachineProfile(BaseVirtualMachineProfile baseVirtualMachineProfile) {
        this.baseVirtualMachineProfile = baseVirtualMachineProfile;
        return this;
    }

    public String computeApiVersion() {
        return this.computeApiVersion;
    }

    public ComputeProfile withComputeApiVersion(String computeApiVersion) {
        this.computeApiVersion = computeApiVersion;
        return this;
    }

    public Integer platformFaultDomainCount() {
        return this.platformFaultDomainCount;
    }

    public ComputeProfile withPlatformFaultDomainCount(Integer platformFaultDomainCount) {
        this.platformFaultDomainCount = platformFaultDomainCount;
        return this;
    }

    public AdditionalCapabilities additionalVirtualMachineCapabilities() {
        return this.additionalVirtualMachineCapabilities;
    }

    public ComputeProfile withAdditionalVirtualMachineCapabilities(AdditionalCapabilities additionalVirtualMachineCapabilities) {
        this.additionalVirtualMachineCapabilities = additionalVirtualMachineCapabilities;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("baseVirtualMachineProfile", (JsonSerializable)this.baseVirtualMachineProfile);
        jsonWriter.writeStringField("computeApiVersion", this.computeApiVersion);
        jsonWriter.writeNumberField("platformFaultDomainCount", (Number)this.platformFaultDomainCount);
        jsonWriter.writeJsonField("additionalVirtualMachineCapabilities", (JsonSerializable)this.additionalVirtualMachineCapabilities);
        return jsonWriter.writeEndObject();
    }

    public static ComputeProfile fromJson(JsonReader jsonReader) throws IOException {
        return (ComputeProfile)jsonReader.readObject(reader -> {
            ComputeProfile deserializedComputeProfile = new ComputeProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("baseVirtualMachineProfile".equals(fieldName)) {
                    deserializedComputeProfile.baseVirtualMachineProfile = BaseVirtualMachineProfile.fromJson(reader);
                    continue;
                }
                if ("computeApiVersion".equals(fieldName)) {
                    deserializedComputeProfile.computeApiVersion = reader.getString();
                    continue;
                }
                if ("platformFaultDomainCount".equals(fieldName)) {
                    deserializedComputeProfile.platformFaultDomainCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("additionalVirtualMachineCapabilities".equals(fieldName)) {
                    deserializedComputeProfile.additionalVirtualMachineCapabilities = AdditionalCapabilities.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedComputeProfile;
        });
    }
}

