/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.computefleet.ComputeFleetManager;
import com.azure.resourcemanager.computefleet.fluent.models.FleetInner;
import com.azure.resourcemanager.computefleet.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.computefleet.models.Fleet;
import com.azure.resourcemanager.computefleet.models.FleetProperties;
import com.azure.resourcemanager.computefleet.models.FleetUpdate;
import com.azure.resourcemanager.computefleet.models.ManagedServiceIdentity;
import com.azure.resourcemanager.computefleet.models.ManagedServiceIdentityUpdate;
import com.azure.resourcemanager.computefleet.models.Plan;
import com.azure.resourcemanager.computefleet.models.ResourcePlanUpdate;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class FleetImpl
implements Fleet,
Fleet.Definition,
Fleet.Update {
    private FleetInner innerObject;
    private final ComputeFleetManager serviceManager;
    private String resourceGroupName;
    private String fleetName;
    private FleetUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public FleetProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public List<String> zones() {
        List<String> inner = this.innerModel().zones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public Plan plan() {
        return this.innerModel().plan();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public FleetInner innerModel() {
        return this.innerObject;
    }

    private ComputeFleetManager manager() {
        return this.serviceManager;
    }

    @Override
    public FleetImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Fleet create() {
        this.innerObject = this.serviceManager.serviceClient().getFleets().createOrUpdate(this.resourceGroupName, this.fleetName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Fleet create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getFleets().createOrUpdate(this.resourceGroupName, this.fleetName, this.innerModel(), context);
        return this;
    }

    FleetImpl(String name, ComputeFleetManager serviceManager) {
        this.innerObject = new FleetInner();
        this.serviceManager = serviceManager;
        this.fleetName = name;
    }

    @Override
    public FleetImpl update() {
        this.updateProperties = new FleetUpdate();
        return this;
    }

    @Override
    public Fleet apply() {
        this.innerObject = this.serviceManager.serviceClient().getFleets().update(this.resourceGroupName, this.fleetName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public Fleet apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getFleets().update(this.resourceGroupName, this.fleetName, this.updateProperties, context);
        return this;
    }

    FleetImpl(FleetInner innerObject, ComputeFleetManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.fleetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "fleets");
    }

    @Override
    public Fleet refresh() {
        this.innerObject = (FleetInner)((Object)this.serviceManager.serviceClient().getFleets().getByResourceGroupWithResponse(this.resourceGroupName, this.fleetName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Fleet refresh(Context context) {
        this.innerObject = (FleetInner)((Object)this.serviceManager.serviceClient().getFleets().getByResourceGroupWithResponse(this.resourceGroupName, this.fleetName, context).getValue());
        return this;
    }

    @Override
    public void cancel() {
        this.serviceManager.fleets().cancel(this.resourceGroupName, this.fleetName);
    }

    @Override
    public void cancel(Context context) {
        this.serviceManager.fleets().cancel(this.resourceGroupName, this.fleetName, context);
    }

    @Override
    public FleetImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public FleetImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public FleetImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public FleetImpl withProperties(FleetProperties properties) {
        if (this.isInCreateMode()) {
            this.innerModel().withProperties(properties);
            return this;
        }
        this.updateProperties.withProperties(properties);
        return this;
    }

    @Override
    public FleetImpl withZones(List<String> zones) {
        this.innerModel().withZones(zones);
        return this;
    }

    @Override
    public FleetImpl withIdentity(ManagedServiceIdentity identity) {
        this.innerModel().withIdentity(identity);
        return this;
    }

    @Override
    public FleetImpl withPlan(Plan plan) {
        this.innerModel().withPlan(plan);
        return this;
    }

    @Override
    public FleetImpl withIdentity(ManagedServiceIdentityUpdate identity) {
        this.updateProperties.withIdentity(identity);
        return this;
    }

    @Override
    public FleetImpl withPlan(ResourcePlanUpdate plan) {
        this.updateProperties.withPlan(plan);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

