/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.computefleet.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.computefleet.models.FleetProperties;
import com.azure.resourcemanager.computefleet.models.ManagedServiceIdentity;
import com.azure.resourcemanager.computefleet.models.Plan;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class FleetInner
extends Resource {
    private FleetProperties properties;
    private List<String> zones;
    private ManagedServiceIdentity identity;
    private Plan plan;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public FleetProperties properties() {
        return this.properties;
    }

    public FleetInner withProperties(FleetProperties properties) {
        this.properties = properties;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public FleetInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public FleetInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Plan plan() {
        return this.plan;
    }

    public FleetInner withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public FleetInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public FleetInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("plan", (JsonSerializable)this.plan);
        return jsonWriter.writeEndObject();
    }

    public static FleetInner fromJson(JsonReader jsonReader) throws IOException {
        return (FleetInner)((Object)jsonReader.readObject(reader -> {
            FleetInner deserializedFleetInner = new FleetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedFleetInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFleetInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFleetInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedFleetInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedFleetInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFleetInner.properties = FleetProperties.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedFleetInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedFleetInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("plan".equals(fieldName)) {
                    deserializedFleetInner.plan = Plan.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedFleetInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFleetInner;
        }));
    }
}

