/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import com.azure.resourcemanager.compute.models.IpVersions;
import com.azure.resourcemanager.compute.models.PublicIpAddressSku;
import com.azure.resourcemanager.compute.models.PublicIpAllocationMethod;
import com.azure.resourcemanager.compute.models.VirtualMachineIpTag;
import com.azure.resourcemanager.compute.models.VirtualMachinePublicIpAddressDnsSettingsConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class VirtualMachinePublicIpAddressConfiguration {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachinePublicIpAddressConfiguration.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="sku")
    private PublicIpAddressSku sku;
    @JsonProperty(value="properties.idleTimeoutInMinutes")
    private Integer idleTimeoutInMinutes;
    @JsonProperty(value="properties.deleteOption")
    private DeleteOptions deleteOption;
    @JsonProperty(value="properties.dnsSettings")
    private VirtualMachinePublicIpAddressDnsSettingsConfiguration dnsSettings;
    @JsonProperty(value="properties.ipTags")
    private List<VirtualMachineIpTag> ipTags;
    @JsonProperty(value="properties.publicIPPrefix")
    private SubResource publicIpPrefix;
    @JsonProperty(value="properties.publicIPAddressVersion")
    private IpVersions publicIpAddressVersion;
    @JsonProperty(value="properties.publicIPAllocationMethod")
    private PublicIpAllocationMethod publicIpAllocationMethod;

    public String name() {
        return this.name;
    }

    public VirtualMachinePublicIpAddressConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public PublicIpAddressSku sku() {
        return this.sku;
    }

    public VirtualMachinePublicIpAddressConfiguration withSku(PublicIpAddressSku sku) {
        this.sku = sku;
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public VirtualMachinePublicIpAddressConfiguration withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public DeleteOptions deleteOption() {
        return this.deleteOption;
    }

    public VirtualMachinePublicIpAddressConfiguration withDeleteOption(DeleteOptions deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public VirtualMachinePublicIpAddressDnsSettingsConfiguration dnsSettings() {
        return this.dnsSettings;
    }

    public VirtualMachinePublicIpAddressConfiguration withDnsSettings(VirtualMachinePublicIpAddressDnsSettingsConfiguration dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public List<VirtualMachineIpTag> ipTags() {
        return this.ipTags;
    }

    public VirtualMachinePublicIpAddressConfiguration withIpTags(List<VirtualMachineIpTag> ipTags) {
        this.ipTags = ipTags;
        return this;
    }

    public SubResource publicIpPrefix() {
        return this.publicIpPrefix;
    }

    public VirtualMachinePublicIpAddressConfiguration withPublicIpPrefix(SubResource publicIpPrefix) {
        this.publicIpPrefix = publicIpPrefix;
        return this;
    }

    public IpVersions publicIpAddressVersion() {
        return this.publicIpAddressVersion;
    }

    public VirtualMachinePublicIpAddressConfiguration withPublicIpAddressVersion(IpVersions publicIpAddressVersion) {
        this.publicIpAddressVersion = publicIpAddressVersion;
        return this;
    }

    public PublicIpAllocationMethod publicIpAllocationMethod() {
        return this.publicIpAllocationMethod;
    }

    public VirtualMachinePublicIpAddressConfiguration withPublicIpAllocationMethod(PublicIpAllocationMethod publicIpAllocationMethod) {
        this.publicIpAllocationMethod = publicIpAllocationMethod;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model VirtualMachinePublicIpAddressConfiguration"));
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
        if (this.ipTags() != null) {
            this.ipTags().forEach(e -> e.validate());
        }
    }
}

