/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import com.azure.resourcemanager.compute.models.VirtualMachineNetworkInterfaceDnsSettingsConfiguration;
import com.azure.resourcemanager.compute.models.VirtualMachineNetworkInterfaceIpConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class VirtualMachineNetworkInterfaceConfiguration {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineNetworkInterfaceConfiguration.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="properties.primary")
    private Boolean primary;
    @JsonProperty(value="properties.deleteOption")
    private DeleteOptions deleteOption;
    @JsonProperty(value="properties.enableAcceleratedNetworking")
    private Boolean enableAcceleratedNetworking;
    @JsonProperty(value="properties.enableFpga")
    private Boolean enableFpga;
    @JsonProperty(value="properties.enableIPForwarding")
    private Boolean enableIpForwarding;
    @JsonProperty(value="properties.networkSecurityGroup")
    private SubResource networkSecurityGroup;
    @JsonProperty(value="properties.dnsSettings")
    private VirtualMachineNetworkInterfaceDnsSettingsConfiguration dnsSettings;
    @JsonProperty(value="properties.ipConfigurations")
    private List<VirtualMachineNetworkInterfaceIpConfiguration> ipConfigurations;
    @JsonProperty(value="properties.dscpConfiguration")
    private SubResource dscpConfiguration;

    public String name() {
        return this.name;
    }

    public VirtualMachineNetworkInterfaceConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean primary() {
        return this.primary;
    }

    public VirtualMachineNetworkInterfaceConfiguration withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    public DeleteOptions deleteOption() {
        return this.deleteOption;
    }

    public VirtualMachineNetworkInterfaceConfiguration withDeleteOption(DeleteOptions deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public Boolean enableAcceleratedNetworking() {
        return this.enableAcceleratedNetworking;
    }

    public VirtualMachineNetworkInterfaceConfiguration withEnableAcceleratedNetworking(Boolean enableAcceleratedNetworking) {
        this.enableAcceleratedNetworking = enableAcceleratedNetworking;
        return this;
    }

    public Boolean enableFpga() {
        return this.enableFpga;
    }

    public VirtualMachineNetworkInterfaceConfiguration withEnableFpga(Boolean enableFpga) {
        this.enableFpga = enableFpga;
        return this;
    }

    public Boolean enableIpForwarding() {
        return this.enableIpForwarding;
    }

    public VirtualMachineNetworkInterfaceConfiguration withEnableIpForwarding(Boolean enableIpForwarding) {
        this.enableIpForwarding = enableIpForwarding;
        return this;
    }

    public SubResource networkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    public VirtualMachineNetworkInterfaceConfiguration withNetworkSecurityGroup(SubResource networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
        return this;
    }

    public VirtualMachineNetworkInterfaceDnsSettingsConfiguration dnsSettings() {
        return this.dnsSettings;
    }

    public VirtualMachineNetworkInterfaceConfiguration withDnsSettings(VirtualMachineNetworkInterfaceDnsSettingsConfiguration dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public List<VirtualMachineNetworkInterfaceIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public VirtualMachineNetworkInterfaceConfiguration withIpConfigurations(List<VirtualMachineNetworkInterfaceIpConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public SubResource dscpConfiguration() {
        return this.dscpConfiguration;
    }

    public VirtualMachineNetworkInterfaceConfiguration withDscpConfiguration(SubResource dscpConfiguration) {
        this.dscpConfiguration = dscpConfiguration;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model VirtualMachineNetworkInterfaceConfiguration"));
        }
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
        if (this.ipConfigurations() != null) {
            this.ipConfigurations().forEach(e -> e.validate());
        }
    }
}

