/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.CapacityReservationInstanceView;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import com.azure.resourcemanager.compute.models.UpdateResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class CapacityReservationUpdate
extends UpdateResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CapacityReservationUpdate.class);
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="properties.reservationId", access=JsonProperty.Access.WRITE_ONLY)
    private String reservationId;
    @JsonProperty(value="properties.virtualMachinesAssociated", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceReadOnly> virtualMachinesAssociated;
    @JsonProperty(value="properties.provisioningTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime provisioningTime;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private CapacityReservationInstanceView instanceView;

    public Sku sku() {
        return this.sku;
    }

    public CapacityReservationUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String reservationId() {
        return this.reservationId;
    }

    public List<SubResourceReadOnly> virtualMachinesAssociated() {
        return this.virtualMachinesAssociated;
    }

    public OffsetDateTime provisioningTime() {
        return this.provisioningTime;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public CapacityReservationInstanceView instanceView() {
        return this.instanceView;
    }

    @Override
    public CapacityReservationUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.virtualMachinesAssociated() != null) {
            this.virtualMachinesAssociated().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }
}

