/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.UpdateResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class AvailabilitySetUpdate
extends UpdateResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AvailabilitySetUpdate.class);
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="properties.platformUpdateDomainCount")
    private Integer platformUpdateDomainCount;
    @JsonProperty(value="properties.platformFaultDomainCount")
    private Integer platformFaultDomainCount;
    @JsonProperty(value="properties.virtualMachines")
    private List<SubResource> virtualMachines;
    @JsonProperty(value="properties.proximityPlacementGroup")
    private SubResource proximityPlacementGroup;
    @JsonProperty(value="properties.statuses", access=JsonProperty.Access.WRITE_ONLY)
    private List<InstanceViewStatus> statuses;

    public Sku sku() {
        return this.sku;
    }

    public AvailabilitySetUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Integer platformUpdateDomainCount() {
        return this.platformUpdateDomainCount;
    }

    public AvailabilitySetUpdate withPlatformUpdateDomainCount(Integer platformUpdateDomainCount) {
        this.platformUpdateDomainCount = platformUpdateDomainCount;
        return this;
    }

    public Integer platformFaultDomainCount() {
        return this.platformFaultDomainCount;
    }

    public AvailabilitySetUpdate withPlatformFaultDomainCount(Integer platformFaultDomainCount) {
        this.platformFaultDomainCount = platformFaultDomainCount;
        return this;
    }

    public List<SubResource> virtualMachines() {
        return this.virtualMachines;
    }

    public AvailabilitySetUpdate withVirtualMachines(List<SubResource> virtualMachines) {
        this.virtualMachines = virtualMachines;
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.proximityPlacementGroup;
    }

    public AvailabilitySetUpdate withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        this.proximityPlacementGroup = proximityPlacementGroup;
        return this;
    }

    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    @Override
    public AvailabilitySetUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
    }
}

