/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.VirtualMachineImagesClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineImageResourceInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class VirtualMachineImagesClientImpl
implements VirtualMachineImagesClient {
    private final ClientLogger logger = new ClientLogger(VirtualMachineImagesClientImpl.class);
    private final VirtualMachineImagesService service;
    private final ComputeManagementClientImpl client;

    VirtualMachineImagesClientImpl(ComputeManagementClientImpl client) {
        this.service = (VirtualMachineImagesService)RestProxy.create(VirtualMachineImagesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VirtualMachineImageInner>> getWithResponseAsync(String location, String publisherName, String offer, String skus, String version) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (skus == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter skus is required and cannot be null."));
        }
        if (version == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter version is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), location, publisherName, offer, skus, version, "2021-04-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VirtualMachineImageInner>> getWithResponseAsync(String location, String publisherName, String offer, String skus, String version, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (skus == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter skus is required and cannot be null."));
        }
        if (version == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter version is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), location, publisherName, offer, skus, version, "2021-04-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineImageInner> getAsync(String location, String publisherName, String offer, String skus, String version) {
        return this.getWithResponseAsync(location, publisherName, offer, skus, version).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((VirtualMachineImageInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineImageInner get(String location, String publisherName, String offer, String skus, String version) {
        return (VirtualMachineImageInner)((Object)this.getAsync(location, publisherName, offer, skus, version).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VirtualMachineImageInner> getWithResponse(String location, String publisherName, String offer, String skus, String version, Context context) {
        return (Response)this.getWithResponseAsync(location, publisherName, offer, skus, version, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineImageResourceInner>>> listWithResponseAsync(String location, String publisherName, String offer, String skus, String expand, Integer top, String orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (skus == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter skus is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), location, publisherName, offer, skus, expand, top, orderby, "2021-04-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineImageResourceInner>>> listWithResponseAsync(String location, String publisherName, String offer, String skus, String expand, Integer top, String orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (skus == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter skus is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), location, publisherName, offer, skus, expand, top, orderby, "2021-04-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<VirtualMachineImageResourceInner>> listAsync(String location, String publisherName, String offer, String skus, String expand, Integer top, String orderby) {
        return this.listWithResponseAsync(location, publisherName, offer, skus, expand, top, orderby).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<VirtualMachineImageResourceInner>> listAsync(String location, String publisherName, String offer, String skus) {
        String expand = null;
        Integer top = null;
        String orderby = null;
        return this.listWithResponseAsync(location, publisherName, offer, skus, expand, top, orderby).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<VirtualMachineImageResourceInner> list(String location, String publisherName, String offer, String skus) {
        String expand = null;
        Integer top = null;
        String orderby = null;
        return (List)this.listAsync(location, publisherName, offer, skus, expand, top, orderby).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<VirtualMachineImageResourceInner>> listWithResponse(String location, String publisherName, String offer, String skus, String expand, Integer top, String orderby, Context context) {
        return (Response)this.listWithResponseAsync(location, publisherName, offer, skus, expand, top, orderby, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineImageResourceInner>>> listOffersWithResponseAsync(String location, String publisherName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOffers(this.client.getEndpoint(), location, publisherName, "2021-04-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineImageResourceInner>>> listOffersWithResponseAsync(String location, String publisherName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listOffers(this.client.getEndpoint(), location, publisherName, "2021-04-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<VirtualMachineImageResourceInner>> listOffersAsync(String location, String publisherName) {
        return this.listOffersWithResponseAsync(location, publisherName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<VirtualMachineImageResourceInner> listOffers(String location, String publisherName) {
        return (List)this.listOffersAsync(location, publisherName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<VirtualMachineImageResourceInner>> listOffersWithResponse(String location, String publisherName, Context context) {
        return (Response)this.listOffersWithResponseAsync(location, publisherName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineImageResourceInner>>> listPublishersWithResponseAsync(String location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPublishers(this.client.getEndpoint(), location, "2021-04-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineImageResourceInner>>> listPublishersWithResponseAsync(String location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listPublishers(this.client.getEndpoint(), location, "2021-04-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<VirtualMachineImageResourceInner>> listPublishersAsync(String location) {
        return this.listPublishersWithResponseAsync(location).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<VirtualMachineImageResourceInner> listPublishers(String location) {
        return (List)this.listPublishersAsync(location).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<VirtualMachineImageResourceInner>> listPublishersWithResponse(String location, Context context) {
        return (Response)this.listPublishersWithResponseAsync(location, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<VirtualMachineImageResourceInner>>> listSkusWithResponseAsync(String location, String publisherName, String offer) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSkus(this.client.getEndpoint(), location, publisherName, offer, "2021-04-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<VirtualMachineImageResourceInner>>> listSkusWithResponseAsync(String location, String publisherName, String offer, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publisherName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publisherName is required and cannot be null."));
        }
        if (offer == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter offer is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSkus(this.client.getEndpoint(), location, publisherName, offer, "2021-04-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<VirtualMachineImageResourceInner>> listSkusAsync(String location, String publisherName, String offer) {
        return this.listSkusWithResponseAsync(location, publisherName, offer).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<VirtualMachineImageResourceInner> listSkus(String location, String publisherName, String offer) {
        return (List)this.listSkusAsync(location, publisherName, offer).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<VirtualMachineImageResourceInner>> listSkusWithResponse(String location, String publisherName, String offer, Context context) {
        return (Response)this.listSkusWithResponseAsync(location, publisherName, offer, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    private static interface VirtualMachineImagesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions/{version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineImageInner>> get(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="publisherName") String var3, @PathParam(value="offer") String var4, @PathParam(value="skus") String var5, @PathParam(value="version") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus/{skus}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<List<VirtualMachineImageResourceInner>>> list(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="publisherName") String var3, @PathParam(value="offer") String var4, @PathParam(value="skus") String var5, @QueryParam(value="$expand") String var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="api-version") String var9, @PathParam(value="subscriptionId") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<List<VirtualMachineImageResourceInner>>> listOffers(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="publisherName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<List<VirtualMachineImageResourceInner>>> listPublishers(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/publishers/{publisherName}/artifacttypes/vmimage/offers/{offer}/skus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<List<VirtualMachineImageResourceInner>>> listSkus(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="publisherName") String var3, @PathParam(value="offer") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

